/*
 * Decompiled with CFR 0.152.
 */
package FESI.ClassFile;

import FESI.ClassFile.ClassFile;
import FESI.ClassFile.ConstantPoolEntry;
import FESI.ClassFile.UTF8Constant;
import java.io.DataOutputStream;
import java.io.IOException;

class NameAndTypeConstant
extends ConstantPoolEntry {
    private UTF8Constant name;
    private UTF8Constant desc;

    NameAndTypeConstant(String string, String string2, ClassFile classFile) {
        super((byte)12, classFile);
        this.name = new UTF8Constant(string, classFile);
        this.desc = new UTF8Constant(string2, classFile);
        this.addToConstantPool();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (ConstantPoolEntry.debug()) {
            System.err.println(String.valueOf(this.getConstantPoolIndex()) + " NAME: " + this.name.getConstantPoolIndex() + " TYPE: " + this.desc.getConstantPoolIndex());
        }
        dataOutputStream.writeByte(this.getTag());
        dataOutputStream.writeShort(this.name.getConstantPoolIndex());
        dataOutputStream.writeShort(this.desc.getConstantPoolIndex());
    }

    String getName() {
        return this.name.getString();
    }

    String getDescriptor() {
        return this.desc.getString();
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.name.getString().equals(object) || this.desc.getString().equals(object);
        }
        if (object instanceof NameAndTypeConstant) {
            NameAndTypeConstant nameAndTypeConstant = (NameAndTypeConstant)object;
            return this.name.equals(nameAndTypeConstant.getName()) && this.desc.equals(nameAndTypeConstant.getDescriptor());
        }
        return false;
    }
}

