/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESBoolean;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.PatternCompiler;
import com.oroinc.text.regex.PatternMatcher;

class ESORORegExp
extends ESObject {
    private String regExpString;
    private boolean ignoreCase = false;
    private boolean global = false;
    private Pattern pattern;
    private int groups;
    private PatternCompiler compiler;
    private PatternMatcher matcher;
    private static final String IGNORECASEstring = "ignoreCase".intern();
    private static final int IGNORECASEhash = IGNORECASEstring.hashCode();
    private static final String GLOBALstring = "global".intern();
    private static final int GLOBALhash = GLOBALstring.hashCode();

    ESORORegExp(ESObject eSObject, Evaluator evaluator, PatternCompiler patternCompiler, PatternMatcher patternMatcher, String string) {
        super(eSObject, evaluator);
        this.compiler = patternCompiler;
        this.matcher = patternMatcher;
        this.regExpString = string;
    }

    ESORORegExp(ESObject eSObject, Evaluator evaluator, PatternCompiler patternCompiler, PatternMatcher patternMatcher) {
        super(eSObject, evaluator);
        this.compiler = patternCompiler;
        this.matcher = patternMatcher;
        this.regExpString = "";
    }

    public Pattern getPattern() throws EcmaScriptException {
        if (this.pattern == null) {
            this.compile();
        }
        return this.pattern;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void compile() throws EcmaScriptException {
        try {
            this.pattern = this.compiler.compile(this.regExpString, this.ignoreCase ? 1 : 0);
            return;
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new EcmaScriptException("MalformedPatternException: /" + this.regExpString + "/", malformedPatternException);
        }
    }

    public String getESClassName() {
        return "RegExp";
    }

    public String toString() {
        if (this.regExpString == null) {
            return "/<null>/";
        }
        return "/" + this.regExpString + "/";
    }

    public String toDetailString() {
        return "ES:[Object: builtin " + this.getClass().getName() + ":" + this.toString() + "]";
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (string.equals(IGNORECASEstring)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (string.equals(GLOBALstring)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getPropertyInScope(string, scopeChain, n);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (string.equals(IGNORECASEstring)) {
            return ESBoolean.makeBoolean(this.ignoreCase);
        }
        if (string.equals(GLOBALstring)) {
            return ESBoolean.makeBoolean(this.global);
        }
        return super.getProperty(string, n);
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (n == IGNORECASEhash && string.equals(IGNORECASEstring)) {
            boolean bl = this.ignoreCase;
            this.ignoreCase = ((ESPrimitive)eSValue).booleanValue();
            if (bl != this.ignoreCase) {
                this.pattern = null;
                return;
            }
        } else {
            if (n == GLOBALhash && string.equals(GLOBALstring)) {
                this.global = ((ESPrimitive)eSValue).booleanValue();
                return;
            }
            super.putProperty(string, eSValue, n);
        }
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{GLOBALstring, IGNORECASEstring};
        return stringArray;
    }
}

