package jp.wda.gpss.system;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import jp.wda.gpss.util.Finder;
import jp.wda.gpss.util.FinderElement;

/**
 * p[^NX
 *
 * @version	1.00001	2003/05/16
 * @since		1.00001	2003/05/16
 * @author	amoi
 */
public class InitParamContainerImpl implements InitParamContainer{
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	public InitParamContainerImpl(){
		initparams = new Vector();
	}
	
	// tB[h` ///////////////////////////////////////////////////////////////
	//                                                                          Fields //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	private Vector initparams;

	// CX^X\bh /////////////////////////////////////////////////////////////
	//                                                                Instance Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * p[^ǉ܂B<BR>
	 * @param key p[^
	 * @param value p[^l
	 */
	public void addInitParam(String key, String value){
		initparams.add(new Param(key, value));
	}
	/**
	 * p[^ݒ肵܂B<BR>
	 * ݊ɐݒ肳Ă鏉p[^w肷ƁA
	 * ŏɌoꂽvf㏑ݒ肵܂B
	 * 
	 * @param key p[^
	 * @param value p[^l
	 */
	public void setInitParam(String key, String value){
		Iterator it = new ArrayList(initparams).iterator();
		while(it.hasNext()){
			Param param = (Param)it.next();
			if(key.equals(param.key)){
				param.value = value;
				return;
			}
		}
		initparams.add(new Param(key, value));
	}

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽȌp[^擾܂B<BR>
	 * ̏p[^ݒ肳Ăꍇ́AŏɌoꂽvf擾܂B<BR>
	 * 
	 * @param key p^
	 * @return w肳ꂽL[̏p[^
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParam(String)
	 */
	public String getInitParam(String key){
		return (String)new PFinder(key).get(initparams);
	}
	/**
	 * w肳ꂽȌp[^ꗗ擾܂B
	 * @param key p^
	 * @return w肳ꂽL[̏p[^ꗗ
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParams(String)
	 */
	public List getInitParams(String key){
		return new PFinder(key).getList(initparams);
	}
	/**
	 * SĂ̏p[^擾܂B
	 * @return SĂ̏p[^ꗗ
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParams()
	 */
	public List getInitParams(){
		ArrayList ret = new ArrayList();
		Iterator it = initparams.iterator();
		while(it.hasNext()){
			ret.add(((Param)it.next()).value);
		}
		
		return ret;
	}
	/**
	 * SĂ̏p[^L[擾܂B
	 * @return SĂ̏p[^L[ꗗ
	 * @see jp.wda.gpss.system.InitParamContainer#getInitParamKeys()
	 */
	public List getInitParamKeys(){
		ArrayList ret = new ArrayList();
		Iterator it = initparams.iterator();
		while(it.hasNext()){
			Param param = (Param)it.next();
			if(ret.contains(param.key)){ continue; }
			
			ret.add(param.key);
		}
		
		return ret;
	}

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽp^̒lݒ肳Ă邩mF܂B<BR>
	 * @param key p^<BR>
	 * @return w肳ꂽȌp[^ݒ肳Ăꍇ͐^
	 * @see jp.wda.gpss.system.InitParamContainer#hasInitParam(String)
	 */
	public boolean hasInitParam(String key){
		return getInitParam(key) != null;
	}

	/* ***********************************************************************>> */;
	/**
	 * ̃IuWFNg̏p[^ׂāA
	 * w肳ꂽIuWFNg֐ݒ肵܂B
	 * 
	 * @param to Rs[SockletzIuWFNg
	 */
	public void copyInitParamsTo(InitParamContainerImpl to){
		Iterator it = this.initparams.iterator();
		while(it.hasNext()){
			Param param = (Param)it.next();
			to.addInitParam(param.key, param.value);
		}
	}
	
	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	public class PFinder extends Finder {
		public PFinder(String username){
			super();
			group.add(new PFinderElement(true, username));
		}
		public PFinder(boolean not, String username){
			super();
			group.add(new PFinderElement(not, username));
		}
		public Object getReturnValue(Object elem){ return ((Param)elem).value; }
		
		private class PFinderElement extends FinderElement{
			PFinderElement(boolean not, String key){ super(not, key); }
			public Object getFindValue(Object elem){
				if(!(elem instanceof Param)){
					return null;
				}
				return ((Param)elem).key;
			}
		}
	}
	/**
	 * p[^ێNX
	 */
	class Param{
		Param(String key, String value){
			this.key = key;
			this.value = value;
		}
		String key;
		String value;
	}
}
