package jp.moja.socklet.util.security;

import java.util.HashMap;

import jp.wda.gpss.SocketProcessor;

/**
 * IP̐ڑs`FbJ[
 * @author TakenoriAdachi(TheCoolMuseum)
 */
public class LimitedConnectionPerHostChecker extends ClientChecker {

	private int maxConnection;

	private HashMap connections;

	private int trueOperation;

	private int falseOperation;

	public LimitedConnectionPerHostChecker(
		int max,
		int trueOperation,
		int falseOperation) {
		this.maxConnection = max;
		connections = new HashMap();
		this.trueOperation = trueOperation;
		this.falseOperation = falseOperation;
	}

	public synchronized int enter(SocketProcessor client) {
		int connectionCount = 0;
		String ipAddress = client.getIPAddress();
		Object o = connections.get(ipAddress);

		if (o != null) {
			connectionCount = ((Integer)o).intValue();
		}

		connectionCount++;
		connections.put(ipAddress, new Integer(connectionCount));

		if (connectionCount <= maxConnection) {
			return trueOperation;
		}
		return falseOperation;
	}

	public synchronized void exit(SocketProcessor client) {
		int connectionCount = 0;
		String ipAddress = client.getIPAddress();
		Object o = connections.get(ipAddress);

		if (o != null) {
			connectionCount = ((Integer)o).intValue();
		} else {
			return;
		}

		connectionCount--;

		if (connectionCount > 0) {
			connections.put(ipAddress, new Integer(connectionCount));
		} else {
			connections.remove(ipAddress);
		}
	}
}
