package jp.wda.gpss.system.seasar;

import java.io.File;

import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.Main;
import jp.wda.gpss.system.SystemCommander;

import org.seasar.system.Lifecycle;
import org.seasar.util.SeasarException;

/**
 * SeasarT[rXvOC<BR>
 * <BR>
 * homevpeB̒lɁAGPSSz[fBNgւ̃pXw肵ĂB<BR>
 * ΃pXw肵ꍇ́Aseasar.homȇ΂ɂȂ܂B<BR>
 * configvpeB̒lɁAconfig.xmlݒt@Cw肵ĂB<BR>
 * <BR>
 * <STRIKE>homevpeBݒ肷ꍇ́AKconfigvpeB̑Oɐݒ肵ĂB</STRIKE>
 * <I>ver1.04.02ŏC</I>
 *
 * @version	1.04.02		2003/12/02
 * @since		1.04		2003/11/27
 * @author	amoi
 */
public final class GPSSService implements Lifecycle {
	// RXgN^ ///////////////////////////////////////////////////////////////////
	//                                                                    Constructors //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	ftHg̐ݒpăIuWFNg\zRXgN^
	 */
	public GPSSService(){
		super();
	}

	// vpeB ///////////////////////////////////////////////////////////////////////
	//                                                                      Properties //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 *	GPSSRtBM[Vt@C<BR>
	 */
	private String _config = null;
	/**
	 *	GPSSRtBM[Vt@C擾<BR>
	 *	@return GPSSRtBM[Vt@C
	 */
	public String getConfig(){ return _config; }
	/**
	 *	GPSSRtBM[Vt@Cݒ肷<BR>
	 *	@param s ݒl<BR>
	 */
	public void setConfig(String s){
		this._config = getAbsolutePath(s);
	}

	/* ***********************************************************************>> */;
	/**
	 *	GPSSz[fBNg<BR>
	 */
	private String _gpss_home = null;
	/**
	 *	GPSSz[fBNg擾<BR>
	 *	@return GPSSz[fBNg
	 */
	public String getHome(){ return _gpss_home; }
	/**
	 *	GPSSz[fBNgݒ肷<BR>
	 *	@param s ݒl<BR>
	 */
	public void setHome(String s){
		this._gpss_home = getAbsolutePath(s);
	}

	// I[@[Ch /////////////////////////////////////////////////////////////////
	//                                                               Over Ride Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * SeasarT[rXJn܂B
	 */
	public void start() throws SeasarException {
		System.out.println("GPSST[rXJn܂B");
		System.setProperty("gpss.home", this._gpss_home);
		
		new GPSSStarter(this._config).start();
	}

	/* ***********************************************************************>> */;
	/**
	 * SeasarT[rXI܂B
	 */
	public void stop() throws SeasarException {
		System.setProperty("gpss.home", this._gpss_home);
		Configuration configuration = new Configuration(new File(this._config));
		try{
			configuration.loadConfig();
		}catch(Exception e){
			throw new SeasarException("ESR001");
		}
		
		SystemCommander.main(new String[]{ "" + configuration.getPort(), "shutdown" });
	}

	// \bh /////////////////////////////////////////////////////////////////////
	//                                                                 Private Methods //
	/////////////////////////////////////////////////////////////////////////////////////

	/* ***********************************************************************>> */;
	/**
	 * w肳ꂽpXΎwłꍇAseasar.home̐΃pXɕϊ܂B
	 * 
	 * @param path pX
	 * @return ΎwpX
	 */
	private String getAbsolutePath(String path){
		File result = new File(path);
		if(!result.isAbsolute()){
			result = new File(new File(System.getProperty("seasar.home")), path);
		}
		return result.getAbsolutePath();
	}
	
	// NX ///////////////////////////////////////////////////////////////////////
	//                                                                     Inner Class //
	/////////////////////////////////////////////////////////////////////////////////////
	private class GPSSStarter extends Thread{
		private String _config = null;
	
		GPSSStarter(String config){ this._config = config; }
		public final void run() { Main.main(new String[]{ _config }); }
	}
}

