/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.NumberObject;
import FESI.Data.NumberPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class NumberObject
extends BuiltinFunctionObject {
    private NumberObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "Number", 1);
    }

    public String toString() {
        return "<Number>";
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        if (eSValueArray.length == 0) {
            return new ESNumber(0.0);
        }
        return new ESNumber(eSValueArray[0].doubleValue());
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        NumberPrototype numberPrototype = null;
        ESObject eSObject2 = this.evaluator.getNumberPrototype();
        numberPrototype = new NumberPrototype(eSObject2, this.evaluator);
        numberPrototype.value = eSValueArray.length > 0 ? new ESNumber(eSValueArray[0].doubleValue()) : new ESNumber(0.0);
        return numberPrototype;
    }

    public static NumberObject makeNumberObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        NumberPrototype numberPrototype = new NumberPrototype(objectPrototype, evaluator);
        NumberObject numberObject = new NumberObject(functionPrototype, evaluator);
        try {
            numberObject.putHiddenProperty("prototype", numberPrototype);
            numberObject.putHiddenProperty("length", new ESNumber(1.0));
            numberObject.putHiddenProperty("MAX_VALUE", new ESNumber(Double.MAX_VALUE));
            numberObject.putHiddenProperty("MIN_VALUE", new ESNumber(Double.MIN_VALUE));
            numberObject.putHiddenProperty("NaN", new ESNumber(Double.NaN));
            numberObject.putHiddenProperty("NEGATIVE_INFINITY", new ESNumber(Double.NEGATIVE_INFINITY));
            numberObject.putHiddenProperty("POSITIVE_INFINITY", new ESNumber(Double.POSITIVE_INFINITY));
            numberPrototype.putHiddenProperty("constructor", numberObject);
            numberPrototype.putHiddenProperty("toString", new 1.NumberPrototypeToString("toString", evaluator, functionPrototype));
            numberPrototype.putHiddenProperty("valueOf", new 1.NumberPrototypeValueOf("valueOf", evaluator, functionPrototype));
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        evaluator.setNumberPrototype(numberPrototype);
        return numberObject;
    }
}

