/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Extensions.ESFile;
import FESI.Interpreter.Evaluator;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

class ESStdFile
extends ESFile {
    String name;
    InputStream ins;
    PrintStream outs;

    ESStdFile(ESObject eSObject, Evaluator evaluator, String string, InputStream inputStream) {
        super(eSObject, evaluator);
        this.name = string;
        this.ins = inputStream;
    }

    ESStdFile(ESObject eSObject, Evaluator evaluator, String string, PrintStream printStream) {
        super(eSObject, evaluator);
        this.name = string;
        this.outs = printStream;
    }

    public String toString() {
        return this.name;
    }

    public boolean exists() {
        return true;
    }

    public boolean open() {
        return false;
    }

    public boolean isOpened() {
        return true;
    }

    public boolean close() {
        return false;
    }

    public boolean write(boolean bl, ESValue[] eSValueArray) {
        if (this.outs == null) {
            this.setError(new IllegalStateException("File not opened for writing"));
            return false;
        }
        int n = 0;
        while (n < eSValueArray.length) {
            this.outs.println(eSValueArray[n].toString());
            ++n;
        }
        if (bl) {
            this.outs.println();
        }
        this.outs.flush();
        return true;
    }

    public String readln() {
        if (this.ins == null) {
            this.setError(new IllegalStateException("File not opened for reading"));
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.ins));
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                this.atEOF = true;
                this.setError(new EOFException());
            }
            this.atEOF = false;
            return string;
        }
        catch (IOException iOException) {
            this.setError(iOException);
            return null;
        }
    }

    public boolean eof() {
        if (this.ins == null) {
            this.setError(new IllegalStateException("File not opened for read"));
            return true;
        }
        return this.atEOF;
    }

    public boolean isFile() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean flush() {
        if (this.outs == null) {
            this.setError(new IllegalStateException("File not opened for write"));
            return false;
        }
        return true;
    }

    public long getLength() {
        return -1L;
    }

    public long lastModified() {
        return 0L;
    }

    public boolean remove() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return false;
    }

    public boolean renameTo(ESFile eSFile) {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return false;
    }

    public boolean canRead() {
        return this.ins != null;
    }

    public boolean canWrite() {
        return this.outs != null;
    }

    public String getParent() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return "";
    }

    public String getName() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return "";
    }

    public String getPath() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return "";
    }

    public String getAbsolutePath() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return "";
    }

    public boolean isAbsolute() {
        return true;
    }

    public boolean mkdir() {
        this.setError(new IllegalArgumentException("Operation invalid on standard input/output"));
        return false;
    }

    public String[] list() {
        return null;
    }
}

