/*
 * Decompiled with CFR 0.152.
 */
package FESI.Extensions;

import FESI.Data.ArrayPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNull;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.ESGNURegExp;
import FESI.Extensions.Extension;
import FESI.Extensions.GNURegExp;
import FESI.Interpreter.Evaluator;
import gnu.regexp.RE;
import gnu.regexp.REMatch;

public class GNURegExp
extends Extension {
    private static final String INDEXstring = "index";
    private static final int INDEXhash = "index".hashCode();
    private static final String INPUTstring = "input";
    private static final int INPUThash = "input".hashCode();
    private Evaluator evaluator;
    private ESObject esRegExpPrototype;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        ObjectPrototype objectPrototype = (ObjectPrototype)evaluator.getObjectPrototype();
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.esRegExpPrototype = new ESGNURegExp(objectPrototype, evaluator);
        GlobalObjectRegExp globalObjectRegExp = new GlobalObjectRegExp("RegExp", evaluator, functionPrototype);
        globalObjectRegExp.putHiddenProperty("prototype", this.esRegExpPrototype);
        globalObjectRegExp.putHiddenProperty("length", new ESNumber(1.0));
        this.esRegExpPrototype.putHiddenProperty("constructor", globalObjectRegExp);
        this.esRegExpPrototype.putHiddenProperty("test", new ESRegExpPrototypeTest("test", evaluator, functionPrototype));
        this.esRegExpPrototype.putHiddenProperty("exec", new ESRegExpPrototypeExec("exec", evaluator, functionPrototype));
        globalObject.putHiddenProperty("RegExp", globalObjectRegExp);
        ESObject eSObject = evaluator.getStringPrototype();
        eSObject.putHiddenProperty("search", new 1.StringPrototypeSearch("search", evaluator, functionPrototype));
        eSObject.putHiddenProperty("replace", new 1.StringPrototypeReplace("replace", evaluator, functionPrototype));
        eSObject.putHiddenProperty("match", new 1.StringPrototypeMatch("match", evaluator, functionPrototype));
        eSObject.putHiddenProperty("split", new 1.StringPrototypeSplit("split", evaluator, functionPrototype));
    }

    class ESRegExpPrototypeTest
    extends BuiltinFunctionObject {
        ESRegExpPrototypeTest(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            GNURegExp.this = GNURegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("test requires 1 string argument");
            }
            RE rE = ((ESGNURegExp)eSObject).getPattern();
            boolean bl = rE.getMatch(eSValueArray[0].toString()) != null;
            return ESBoolean.makeBoolean(bl);
        }
    }

    class ESRegExpPrototypeExec
    extends BuiltinFunctionObject {
        ESRegExpPrototypeExec(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            GNURegExp.this = GNURegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            String string;
            if (eSValueArray.length < 1) {
                throw new EcmaScriptException("exec requires 1 string argument");
            }
            RE rE = ((ESGNURegExp)eSObject).getPattern();
            REMatch rEMatch = rE.getMatch(string = eSValueArray[0].toString());
            if (rEMatch != null) {
                int n = rE.getNumSubs() + 1;
                ESObject eSObject2 = this.evaluator.getArrayPrototype();
                ArrayPrototype arrayPrototype = new ArrayPrototype(eSObject2, this.evaluator);
                arrayPrototype.setSize(n);
                arrayPrototype.putProperty(INDEXstring, new ESNumber(rEMatch.getStartIndex()), INDEXhash);
                arrayPrototype.putProperty(INPUTstring, new ESString(string), INPUThash);
                int n2 = 0;
                while (n2 < n) {
                    String string2 = rEMatch.toString(n2);
                    arrayPrototype.setElementAt(new ESString(string2 == null ? "" : string2), n2);
                    ++n2;
                }
                return arrayPrototype;
            }
            return ESNull.theNull;
        }
    }

    class GlobalObjectRegExp
    extends BuiltinFunctionObject {
        GlobalObjectRegExp(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super(functionPrototype, evaluator, string, 1);
            GNURegExp.this = GNURegExp.this;
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESGNURegExp eSGNURegExp = null;
            if (eSValueArray.length == 0) {
                throw new EcmaScriptException("GNURegExp requires 1 argument");
            }
            if (eSValueArray.length == 1) {
                eSGNURegExp = new ESGNURegExp(GNURegExp.this.esRegExpPrototype, this.evaluator, eSValueArray[0].toString());
            }
            return eSGNURegExp;
        }
    }
}

