/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESLoader;
import FESI.Interpreter.LocalClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class FESIResourceConnection
extends URLConnection {
    private static boolean debug;
    private Object resource;
    private String cookie;
    private String name;
    private final String prefix = "FESI";
    private final int prefixLength = "FESI".length();

    public FESIResourceConnection(URL uRL) throws MalformedURLException, IOException {
        super(uRL);
        String string;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** new FESIResourceConnection('" + uRL + "')");
        }
        if ((string = uRL.getFile()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("FESI")) {
            throw new MalformedURLException("FESIResource file should start with /FESI");
        }
        this.cookie = string.substring(this.prefixLength, string.indexOf("/+/"));
        this.name = string.substring(string.indexOf("/+/") + 3);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** cookie: " + this.cookie + ", name: " + this.name);
        }
    }

    public void connect() throws IOException {
        Object object;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Connect: cookie: " + this.cookie + ", name: " + this.name);
        }
        if ((object = LocalClassLoader.getLocalResource(this.cookie, this.name)) == null) {
            this.resource = null;
            return;
        }
        this.resource = object;
    }

    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.resource;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.resource instanceof InputStream) {
            return (InputStream)this.resource;
        }
        return LocalClassLoader.getLocalResourceAsStream(this.cookie, this.name);
    }
}

