/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESObject;
import FESI.Data.ESReference;
import FESI.Data.ESValue;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;

public class ScopeChain {
    private ScopeChain previousElement;
    private ESObject thisElement;

    ScopeChain(ESObject eSObject, ScopeChain scopeChain) {
        this.previousElement = scopeChain;
        this.thisElement = eSObject;
    }

    ScopeChain previousScope() {
        return this.previousElement;
    }

    public ESReference getReference(String string) throws EcmaScriptException {
        return this.getReference(string, string.hashCode());
    }

    public ESReference getReference(String string, int n) throws EcmaScriptException {
        ScopeChain scopeChain = this;
        do {
            if (!scopeChain.thisElement.hasProperty(string, n)) continue;
            return new ESReference(scopeChain.thisElement, string, n);
        } while ((scopeChain = scopeChain.previousElement) != null);
        return new ESReference(null, string, n);
    }

    public ESValue getValue(String string) throws EcmaScriptException {
        return this.getValue(string, string.hashCode());
    }

    public ESValue getValue(String string, int n) throws EcmaScriptException {
        return this.thisElement.getPropertyInScope(string, this.previousElement, n);
    }

    public ESValue doIndirectCall(Evaluator evaluator, ESObject eSObject, String string, int n, ESValue[] eSValueArray) throws EcmaScriptException {
        return this.thisElement.doIndirectCallInScope(evaluator, this.previousElement, eSObject, string, n, eSValueArray);
    }
}

