/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.Exceptions.ProgrammingError;
import FESI.swinggui.SwingConsole;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class Editor
extends JPanel {
    private JTextComponent editor;
    private JMenuBar menubar;
    private File currentFile;
    private boolean dirty = false;
    private String defaultTitle;
    protected FileDialog fileDialog;
    private SwingConsole mainConsole;
    private DocumentListener theDocumentListener = new 1();

    Editor(SwingConsole swingConsole) {
        super(true);
        this.mainConsole = swingConsole;
        this.init();
    }

    void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.editor = new JTextArea();
        this.editor.setFont(new Font("Monospaced", 0, 12));
        Document document = this.editor.getDocument();
        document.addDocumentListener(this.theDocumentListener);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.editor);
        jViewport.setBackingStoreEnabled(false);
        this.menubar = this.createMenubar();
        this.add("North", this.menubar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", jScrollPane);
        this.add("Center", jPanel);
    }

    boolean checkDirty() {
        if (this.dirty) {
            JOptionPane jOptionPane = new JOptionPane();
            int n = JOptionPane.showConfirmDialog(this, "Save changes in " + this.getWindowBaseTitle() + " ?", "FESI Editor", 1, 2, null);
            if (n == 2) {
                return true;
            }
            if (n == 0) {
                this.commandSave();
                return false;
            }
            return false;
        }
        return false;
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected JMenuBar getMenubar() {
        return this.menubar;
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("New  Ctrl+N");
        jMenuItem.addActionListener(new 2());
        jMenu.add(jMenuItem);
        this.registerKeyboardAction(new 3(), KeyStroke.getKeyStroke(78, 2), 2);
        JMenuItem jMenuItem2 = new JMenuItem("Open... Ctrl+O");
        jMenuItem2.setMnemonic('O');
        jMenuItem2.addActionListener(new 4());
        jMenu.add(jMenuItem2);
        this.registerKeyboardAction(new 5(), KeyStroke.getKeyStroke(79, 2), 2);
        JMenuItem jMenuItem3 = new JMenuItem("Close");
        jMenuItem3.setMnemonic('C');
        jMenuItem3.addActionListener(new 6());
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Save  Ctrl+S");
        jMenuItem4.setMnemonic('S');
        jMenuItem4.addActionListener(new 7());
        jMenu.add(jMenuItem4);
        this.registerKeyboardAction(new 8(), KeyStroke.getKeyStroke(83, 2), 2);
        JMenuItem jMenuItem5 = new JMenuItem("Save as..");
        jMenuItem5.setMnemonic('a');
        jMenuItem5.addActionListener(new 9());
        jMenu.add(jMenuItem5);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic('E');
        JMenuItem jMenuItem6 = new JMenuItem("Cut");
        jMenuItem6.setMnemonic('t');
        jMenuItem6.addActionListener(new 10());
        jMenu2.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Copy");
        jMenuItem7.setMnemonic('C');
        jMenuItem7.addActionListener(new 11());
        jMenu2.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem("Paste");
        jMenuItem8.setMnemonic('P');
        jMenuItem8.addActionListener(new 12());
        jMenu2.add(jMenuItem8);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu("Run");
        jMenu3.setMnemonic('R');
        JMenuItem jMenuItem9 = new JMenuItem("Execute F4");
        jMenuItem9.setMnemonic('E');
        jMenuItem9.addActionListener(new 13());
        jMenu3.add(jMenuItem9);
        this.registerKeyboardAction(new 14(), KeyStroke.getKeyStroke(115, 0), 2);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic('H');
        JMenuItem jMenuItem10 = new JMenuItem("Content F1");
        jMenuItem10.setMnemonic('C');
        jMenuItem10.addActionListener(new 15());
        jMenu4.add(jMenuItem10);
        this.registerKeyboardAction(new 16(), KeyStroke.getKeyStroke(112, 0), 2);
        JMenuItem jMenuItem11 = new JMenuItem("Commands");
        jMenuItem11.addActionListener(new 17());
        jMenu4.add(jMenuItem11);
        JMenuItem jMenuItem12 = new JMenuItem("About");
        jMenuItem12.setMnemonic('A');
        jMenuItem12.addActionListener(new 18());
        jMenu4.addSeparator();
        jMenu4.add(jMenuItem12);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    public String getWindowBaseTitle() {
        Frame frame = this.getFrame();
        if (this.defaultTitle == null) {
            this.defaultTitle = frame.getTitle();
        }
        if (this.defaultTitle == null) {
            this.defaultTitle = "FESI Editor";
        }
        String string = this.currentFile == null ? this.defaultTitle : this.currentFile.getPath();
        return string;
    }

    public String getWindowTitle() {
        String string = String.valueOf(this.getWindowBaseTitle()) + (this.dirty ? " *" : "");
        return string;
    }

    private void refreshTitle() {
        Frame frame = this.getFrame();
        frame.setTitle(this.getWindowTitle());
    }

    private void setTitle(File file) {
        this.currentFile = file;
        this.dirty = false;
        this.refreshTitle();
    }

    public void loadFile(File file) {
        PlainDocument plainDocument = new PlainDocument();
        this.editor.setDocument(plainDocument);
        this.setTitle(file);
        FileLoader fileLoader = new FileLoader(file, this.editor.getDocument());
        fileLoader.start();
    }

    void commandClose() {
        if (this.checkDirty()) {
            return;
        }
        Frame frame = this.getFrame();
        frame.dispose();
    }

    void commandOpen() {
        if (this.checkDirty()) {
            return;
        }
        Frame frame = this.getFrame();
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(frame);
        }
        this.fileDialog.setMode(0);
        this.fileDialog.show();
        String string = this.fileDialog.getFile();
        if (string == null) {
            return;
        }
        String string2 = this.fileDialog.getDirectory();
        File file = new File(string2, string);
        if (file.exists()) {
            this.loadFile(file);
        }
    }

    public void saveFile(File file) {
        this.setTitle(file);
        try {
            FileWriter fileWriter = new FileWriter(file);
            Document document = this.editor.getDocument();
            String string = null;
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                throw new ProgrammingError("Unexpected exception: " + badLocationException);
            }
            fileWriter.write(string);
            ((Writer)fileWriter).close();
            this.dirty = false;
            this.refreshTitle();
            return;
        }
        catch (IOException iOException) {
            System.out.println("IO Error " + iOException);
            return;
        }
    }

    void commandSaveAs() {
        Frame frame = this.getFrame();
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(frame);
        }
        this.fileDialog.setMode(1);
        this.fileDialog.show();
        String string = this.fileDialog.getFile();
        if (string == null) {
            return;
        }
        String string2 = this.fileDialog.getDirectory();
        File file = new File(string2, string);
        this.saveFile(file);
    }

    void commandSave() {
        if (this.currentFile == null) {
            this.commandSaveAs();
            return;
        }
        this.saveFile(this.currentFile);
    }

    void commandExecute() {
        Document document = this.editor.getDocument();
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new ProgrammingError("Unexpected exception: " + badLocationException);
        }
        Frame frame = this.getFrame();
        int n = this.mainConsole.executeString(string, frame.getTitle());
        if (n > 0) {
            int n2 = string.length();
            char[] cArray = new char[n2];
            string.getChars(0, n2, cArray, 0);
            --n;
            int n3 = -1;
            int n4 = 0;
            while (n4 < n2) {
                if (n == 0) {
                    n3 = n4;
                    break;
                }
                if (cArray[n4] == '\n') {
                    --n;
                }
                ++n4;
            }
            if (n3 >= 0) {
                this.editor.setCaretPosition(n3);
            }
        }
    }

    void commandNew() {
        if (this.checkDirty()) {
            return;
        }
        PlainDocument plainDocument = new PlainDocument();
        plainDocument.addDocumentListener(this.theDocumentListener);
        this.editor.setDocument(plainDocument);
        this.revalidate();
    }

    static /* synthetic */ boolean access$0(Editor editor) {
        return editor.dirty;
    }

    private final class 1
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            Editor.this.dirty = true;
            Editor.this.refreshTitle();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandNew();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandNew();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandOpen();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandOpen();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandClose();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandSave();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandSave();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandSaveAs();
        }

        /* synthetic */ 9() {
        }
    }

    private final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.editor.cut();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.editor.copy();
        }

        /* synthetic */ 11() {
        }
    }

    private final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.editor.paste();
        }

        /* synthetic */ 12() {
        }
    }

    private final class 13
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandExecute();
        }

        /* synthetic */ 13() {
        }
    }

    private final class 14
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.commandExecute();
        }

        /* synthetic */ 14() {
        }
    }

    private final class 15
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.mainConsole.displayHelpWindow();
        }

        /* synthetic */ 15() {
        }
    }

    private final class 16
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.mainConsole.displayHelpWindow();
        }

        /* synthetic */ 16() {
        }
    }

    private final class 17
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.mainConsole.displayHelpText();
        }

        /* synthetic */ 17() {
        }
    }

    private final class 18
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Editor.this.mainConsole.displayAbout();
        }

        /* synthetic */ 18() {
        }
    }

    class FileLoader
    extends Thread {
        Document doc;
        File f;

        FileLoader(File file, Document document) {
            Editor.this = Editor.this;
            this.setPriority(4);
            this.f = file;
            this.doc = document;
        }

        public void run() {
            try {
                int n;
                FileReader fileReader = new FileReader(this.f);
                char[] cArray = new char[4096];
                while ((n = ((Reader)fileReader).read(cArray, 0, cArray.length)) != -1) {
                    this.doc.insertString(this.doc.getLength(), new String(cArray, 0, n), null);
                }
                this.doc.addDocumentListener(Editor.this.theDocumentListener);
                return;
            }
            catch (IOException iOException) {
                System.err.println(iOException.toString());
                return;
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException.getMessage());
                return;
            }
        }
    }
}

