/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;

public class REMatch {
    private String m_match;
    int offset;
    int anchor;
    int[] start;
    int[] end;
    int[] count;

    void finish(CharIndexed charIndexed) {
        this.start[0] = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.end[0]) {
            stringBuffer.append(charIndexed.charAt(n));
            ++n;
        }
        this.m_match = stringBuffer.toString();
        n = 0;
        while (n < this.start.length) {
            if (this.start[n] == -1) {
                this.end[n] = -1;
            }
            ++n;
        }
    }

    void reset(int n) {
        int n2 = n;
        while (n2 < this.start.length) {
            this.end[n2] = -1;
            this.start[n2] = -1;
            this.count[n2] = 0;
            ++n2;
        }
    }

    void clear(int n) {
        this.offset = n;
        int n2 = 0;
        while (n2 < this.start.length) {
            this.end[n2] = -1;
            this.start[n2] = -1;
            this.count[n2] = 0;
            ++n2;
        }
    }

    public String toString() {
        return this.m_match;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int n) {
        if (n >= this.start.length || this.start[n] == -1) {
            return "";
        }
        return this.m_match.substring(this.start[n], this.end[n]);
    }

    public int getSubStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public int getSubEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public String substituteInto(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '$' && Character.isDigit(string.charAt(n + 1))) {
                int n2;
                if ((n2 = Character.digit(string.charAt(++n), 10)) < this.start.length) {
                    stringBuffer.append(this.toString(n2));
                }
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    REMatch(int n, int n2) {
        this.start = new int[n + 1];
        this.end = new int[n + 1];
        this.count = new int[n + 1];
        this.anchor = n2;
        this.clear(n2);
    }
}

