/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.servletunit.FilterConfigImpl;
import com.meterware.servletunit.FilterMetaData;
import com.meterware.servletunit.FilterUrlMap;
import com.meterware.servletunit.ParsedPath;
import com.meterware.servletunit.ServletMetaData;
import com.meterware.servletunit.ServletUnitHttpRequest;
import com.meterware.servletunit.ServletUnitHttpSession;
import com.meterware.servletunit.ServletUnitServletConfig;
import com.meterware.servletunit.ServletUnitServletContext;
import com.meterware.servletunit.SessionListenerDispatcher;
import com.meterware.servletunit.WebResourceConfiguration;
import com.meterware.servletunit.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class WebApplication
implements SessionListenerDispatcher {
    private static final SecurityConstraint NULL_SECURITY_CONSTRAINT = new NullSecurityConstraint();
    private final ServletConfiguration SECURITY_CHECK_CONFIGURATION = new ServletConfiguration((class$com$meterware$servletunit$WebApplication$SecurityCheckServlet == null ? (class$com$meterware$servletunit$WebApplication$SecurityCheckServlet = WebApplication.class$("com.meterware.servletunit.WebApplication$SecurityCheckServlet")) : class$com$meterware$servletunit$WebApplication$SecurityCheckServlet).getName());
    private final WebResourceMapping SECURITY_CHECK_MAPPING = new WebResourceMapping(this.SECURITY_CHECK_CONFIGURATION);
    private WebResourceMap _servletMapping = new WebResourceMap();
    private FilterUrlMap _filterUrlMapping = new FilterUrlMap();
    private Hashtable _filterMapping = new Hashtable();
    private ArrayList _securityConstraints = new ArrayList();
    private ArrayList _contextListeners = new ArrayList();
    private ArrayList _contextAttributeListeners = new ArrayList();
    private ArrayList _sessionListeners = new ArrayList();
    private ArrayList _sessionAttributeListeners = new ArrayList();
    private boolean _useBasicAuthentication;
    private boolean _useFormAuthentication;
    private String _authenticationRealm = "";
    private URL _loginURL;
    private URL _errorURL;
    private Hashtable _contextParameters = new Hashtable();
    private File _contextDir = null;
    private String _contextPath = null;
    private ServletUnitServletContext _servletContext;
    static final int DONT_AUTOLOAD = Integer.MIN_VALUE;
    static final int ANY_LOAD_ORDER = Integer.MAX_VALUE;
    static final FilterMetaData[] NO_FILTERS = new FilterMetaData[0];
    static /* synthetic */ Class class$com$meterware$servletunit$WebApplication$SecurityCheckServlet;
    static /* synthetic */ Class class$javax$servlet$Filter;

    WebApplication() {
        this._contextPath = "";
    }

    WebApplication(Document document) throws MalformedURLException, SAXException {
        this(document, null, "");
    }

    WebApplication(Document document, String contextPath) throws MalformedURLException, SAXException {
        this(document, null, contextPath);
    }

    WebApplication(Document document, File file, String contextPath) throws MalformedURLException, SAXException {
        if (contextPath != null && contextPath.length() > 0 && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException("Context path " + contextPath + " must start with '/'");
        }
        this._contextDir = file;
        this._contextPath = contextPath == null ? "" : contextPath;
        this.registerServlets(document);
        this.registerFilters(document);
        this.extractSecurityConstraints(document);
        this.extractContextParameters(document);
        this.extractLoginConfiguration(document);
        this.extractListeners(document);
        this.notifyContextInitialized();
        this._servletMapping.autoLoadServlets();
    }

    private void extractListeners(Document document) throws SAXException {
        NodeList nl = document.getElementsByTagName("listener");
        int i = 0;
        while (i < nl.getLength()) {
            String listenerName = XMLUtils.getChildNodeValue((Element)nl.item(i), "listener-class").trim();
            try {
                Object listener = Class.forName(listenerName).newInstance();
                if (listener instanceof ServletContextListener) {
                    this._contextListeners.add(listener);
                }
                if (listener instanceof ServletContextAttributeListener) {
                    this._contextAttributeListeners.add(listener);
                }
                if (listener instanceof HttpSessionListener) {
                    this._sessionListeners.add(listener);
                }
                if (listener instanceof HttpSessionAttributeListener) {
                    this._sessionAttributeListeners.add(listener);
                }
            }
            catch (Throwable x) {
                throw new RuntimeException("Unable to load context listener " + listenerName, x);
            }
            ++i;
        }
    }

    private void notifyContextInitialized() {
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        Iterator i = this._contextListeners.iterator();
        while (i.hasNext()) {
            ServletContextListener listener = (ServletContextListener)i.next();
            listener.contextInitialized(event);
        }
    }

    void shutDown() {
        this.destroyServlets();
        this.notifyContextDestroyed();
    }

    private void notifyContextDestroyed() {
        ServletContextEvent event = new ServletContextEvent(this.getServletContext());
        ListIterator i = this._contextListeners.listIterator(this._contextListeners.size());
        while (i.hasPrevious()) {
            ServletContextListener listener = (ServletContextListener)i.previous();
            listener.contextDestroyed(event);
        }
    }

    void sendAttributeAdded(String name, Object value) {
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, value);
        Iterator i = this._contextAttributeListeners.iterator();
        while (i.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)i.next();
            listener.attributeAdded(event);
        }
    }

    void sendAttributeReplaced(String name, Object value) {
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, value);
        Iterator i = this._contextAttributeListeners.iterator();
        while (i.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)i.next();
            listener.attributeReplaced(event);
        }
    }

    void sendAttributeRemoved(String name, Object value) {
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.getServletContext(), name, value);
        Iterator i = this._contextAttributeListeners.iterator();
        while (i.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)i.next();
            listener.attributeRemoved(event);
        }
    }

    private void extractSecurityConstraints(Document document) throws SAXException {
        NodeList nl = document.getElementsByTagName("security-constraint");
        int i = 0;
        while (i < nl.getLength()) {
            this._securityConstraints.add(new SecurityConstraintImpl((Element)nl.item(i)));
            ++i;
        }
    }

    String getContextPath() {
        return this._contextPath;
    }

    ServletContext getServletContext() {
        if (this._servletContext == null) {
            this._servletContext = new ServletUnitServletContext(this);
        }
        return this._servletContext;
    }

    void registerServlet(String resourceName, String servletClassName, Hashtable initParams) {
        this.registerServlet(resourceName, new ServletConfiguration(servletClassName, initParams));
    }

    void registerServlet(String resourceName, ServletConfiguration servletConfiguration) {
        if (!resourceName.startsWith("/") && !resourceName.startsWith("*")) {
            resourceName = "/" + resourceName;
        }
        this._servletMapping.put(resourceName, servletConfiguration);
    }

    void destroyServlets() {
        this._servletMapping.destroyWebResources();
    }

    ServletMetaData getServletRequest(URL url) {
        return this._servletMapping.get(url);
    }

    boolean usesBasicAuthentication() {
        return this._useBasicAuthentication;
    }

    boolean usesFormAuthentication() {
        return this._useFormAuthentication;
    }

    String getAuthenticationRealm() {
        return this._authenticationRealm;
    }

    URL getLoginURL() {
        return this._loginURL;
    }

    URL getErrorURL() {
        return this._errorURL;
    }

    boolean requiresAuthorization(URL url) {
        String file = url.getFile();
        String result = this._contextPath.equals("") ? file : (file.startsWith(this._contextPath) ? file.substring(this._contextPath.length()) : null);
        return this.getControllingConstraint(result) != NULL_SECURITY_CONSTRAINT;
    }

    String[] getPermittedRoles(URL url) {
        String file = url.getFile();
        String result = this._contextPath.equals("") ? file : (file.startsWith(this._contextPath) ? file.substring(this._contextPath.length()) : null);
        return this.getControllingConstraint(result).getPermittedRoles();
    }

    private SecurityConstraint getControllingConstraint(String urlPath) {
        Iterator i = this._securityConstraints.iterator();
        while (i.hasNext()) {
            SecurityConstraint sc = (SecurityConstraint)i.next();
            if (!sc.controlsPath(urlPath)) continue;
            return sc;
        }
        return NULL_SECURITY_CONSTRAINT;
    }

    File getResourceFile(String path) {
        if (this._contextDir == null) {
            return new File(path.substring(1));
        }
        return new File(this._contextDir, path.substring(1));
    }

    Hashtable getContextParameters() {
        return this._contextParameters;
    }

    public void sendSessionCreated(HttpSession session) {
        HttpSessionEvent event = new HttpSessionEvent(session);
        Iterator i = this._sessionListeners.iterator();
        while (i.hasNext()) {
            HttpSessionListener listener = (HttpSessionListener)i.next();
            listener.sessionCreated(event);
        }
    }

    public void sendSessionDestroyed(HttpSession session) {
        HttpSessionEvent event = new HttpSessionEvent(session);
        Iterator i = this._sessionListeners.iterator();
        while (i.hasNext()) {
            HttpSessionListener listener = (HttpSessionListener)i.next();
            listener.sessionDestroyed(event);
        }
    }

    public void sendAttributeAdded(HttpSession session, String name, Object value) {
        HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, value);
        Iterator i = this._sessionAttributeListeners.iterator();
        while (i.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)i.next();
            listener.attributeAdded(event);
        }
    }

    public void sendAttributeReplaced(HttpSession session, String name, Object oldValue) {
        HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, oldValue);
        Iterator i = this._sessionAttributeListeners.iterator();
        while (i.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)i.next();
            listener.attributeReplaced(event);
        }
    }

    public void sendAttributeRemoved(HttpSession session, String name, Object oldValue) {
        HttpSessionBindingEvent event = new HttpSessionBindingEvent(session, name, oldValue);
        Iterator i = this._sessionAttributeListeners.iterator();
        while (i.hasNext()) {
            HttpSessionAttributeListener listener = (HttpSessionAttributeListener)i.next();
            listener.attributeRemoved(event);
        }
    }

    private void registerFilters(Document document) throws SAXException {
        Hashtable nameToClass = new Hashtable();
        NodeList nl = document.getElementsByTagName("filter");
        int i = 0;
        while (i < nl.getLength()) {
            this.registerFilterClass(nameToClass, (Element)nl.item(i));
            ++i;
        }
        nl = document.getElementsByTagName("filter-mapping");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            this.registerFilter(nameToClass, (Element)nl.item(i2));
            ++i2;
        }
    }

    private void registerFilterClass(Dictionary mapping, Element filterElement) throws SAXException {
        String filterName = XMLUtils.getChildNodeValue(filterElement, "filter-name");
        mapping.put(filterName, new FilterConfiguration(filterName, filterElement));
    }

    private void registerFilter(Dictionary mapping, Element filterElement) throws SAXException {
        if (XMLUtils.hasChildNode(filterElement, "servlet-name")) {
            this.registerFilterForServlet(XMLUtils.getChildNodeValue(filterElement, "servlet-name"), (FilterConfiguration)mapping.get(XMLUtils.getChildNodeValue(filterElement, "filter-name")));
        }
        if (XMLUtils.hasChildNode(filterElement, "url-pattern")) {
            this.registerFilterForUrl(XMLUtils.getChildNodeValue(filterElement, "url-pattern"), (FilterConfiguration)mapping.get(XMLUtils.getChildNodeValue(filterElement, "filter-name")));
        }
    }

    private void registerFilterForUrl(String resourceName, FilterConfiguration filterConfiguration) {
        this._filterUrlMapping.put(resourceName, filterConfiguration);
    }

    private void registerFilterForServlet(String servletName, FilterConfiguration filterConfiguration) {
        ArrayList<FilterConfiguration> list = (ArrayList<FilterConfiguration>)this._filterMapping.get(servletName);
        if (list == null) {
            list = new ArrayList<FilterConfiguration>();
            this._filterMapping.put(servletName, list);
        }
        list.add(filterConfiguration);
    }

    private void extractLoginConfiguration(Document document) throws MalformedURLException, SAXException {
        NodeList nl = document.getElementsByTagName("login-config");
        if (nl.getLength() == 1) {
            Element loginConfigElement = (Element)nl.item(0);
            String authenticationMethod = XMLUtils.getChildNodeValue(loginConfigElement, "auth-method", "BASIC");
            this._authenticationRealm = XMLUtils.getChildNodeValue(loginConfigElement, "realm-name", "");
            if (authenticationMethod.equalsIgnoreCase("BASIC")) {
                this._useBasicAuthentication = true;
                if (this._authenticationRealm.length() == 0) {
                    throw new SAXException("No realm specified for BASIC Authorization");
                }
            } else if (authenticationMethod.equalsIgnoreCase("FORM")) {
                this._useFormAuthentication = true;
                if (this._authenticationRealm.length() == 0) {
                    throw new SAXException("No realm specified for FORM Authorization");
                }
                this._loginURL = new URL("http", "localhost", this._contextPath + XMLUtils.getChildNodeValue(loginConfigElement, "form-login-page"));
                this._errorURL = new URL("http", "localhost", this._contextPath + XMLUtils.getChildNodeValue(loginConfigElement, "form-error-page"));
            }
        }
    }

    private void registerServlets(Document document) throws SAXException {
        Hashtable nameToClass = new Hashtable();
        NodeList nl = document.getElementsByTagName("servlet");
        int i = 0;
        while (i < nl.getLength()) {
            this.registerServletClass(nameToClass, (Element)nl.item(i));
            ++i;
        }
        nl = document.getElementsByTagName("servlet-mapping");
        int i2 = 0;
        while (i2 < nl.getLength()) {
            this.registerServlet(nameToClass, (Element)nl.item(i2));
            ++i2;
        }
    }

    private void registerServletClass(Dictionary mapping, Element servletElement) throws SAXException {
        mapping.put(XMLUtils.getChildNodeValue(servletElement, "servlet-name"), new ServletConfiguration(servletElement));
    }

    private void registerServlet(Dictionary mapping, Element servletElement) throws SAXException {
        this.registerServlet(XMLUtils.getChildNodeValue(servletElement, "url-pattern"), (ServletConfiguration)mapping.get(XMLUtils.getChildNodeValue(servletElement, "servlet-name")));
    }

    private void extractContextParameters(Document document) throws SAXException {
        NodeList nl = document.getElementsByTagName("context-param");
        int i = 0;
        while (i < nl.getLength()) {
            Element param = (Element)nl.item(i);
            String name = XMLUtils.getChildNodeValue(param, "param-name");
            String value = XMLUtils.getChildNodeValue(param, "param-value");
            this._contextParameters.put(name, value);
            ++i;
        }
    }

    private static boolean patternMatches(String urlPattern, String urlPath) {
        return urlPattern.equals(urlPath);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WebResourceMap {
        private final Map _exactMatches = new HashMap();
        private final Map _extensions = new HashMap();
        private final Map _urlTree = new HashMap();
        private WebResourceMapping _defaultMapping;

        WebResourceMap() {
        }

        void put(String mapping, WebResourceConfiguration configuration) {
            if (mapping.equals("/")) {
                this._defaultMapping = new WebResourceMapping(configuration);
            } else if (mapping.startsWith("*.")) {
                this._extensions.put(mapping.substring(2), new WebResourceMapping(configuration));
            } else if (!mapping.startsWith("/") || !mapping.endsWith("/*")) {
                this._exactMatches.put(mapping, new WebResourceMapping(configuration));
            } else {
                ParsedPath path = new ParsedPath(mapping);
                Map context = this._urlTree;
                while (path.hasNext()) {
                    String part = path.next();
                    if (part.equals("*")) {
                        context.put("*", new PartialMatchWebResourceMapping(configuration, mapping));
                        return;
                    }
                    if (!context.containsKey(part)) {
                        context.put(part, new HashMap());
                    }
                    context = (Map)context.get(part);
                }
            }
        }

        ServletMetaData get(URL url) {
            String file = url.getFile();
            if (!file.startsWith(WebApplication.this._contextPath)) {
                throw new HttpNotFoundException("File path does not begin with '" + WebApplication.this._contextPath + "'", url);
            }
            String servletPath = this.getServletPath(file.substring(WebApplication.this._contextPath.length()));
            if (servletPath.endsWith("j_security_check")) {
                return new ServletRequestImpl(url, servletPath, WebApplication.this.SECURITY_CHECK_MAPPING, WebApplication.this._filterMapping, WebApplication.this._filterUrlMapping);
            }
            return new ServletRequestImpl(url, servletPath, this.getMapping(servletPath), WebApplication.this._filterMapping, WebApplication.this._filterUrlMapping);
        }

        private String getServletPath(String urlFile) {
            if (urlFile.indexOf(63) < 0) {
                return urlFile;
            }
            return urlFile.substring(0, urlFile.indexOf(63));
        }

        public void destroyWebResources() {
            if (this._defaultMapping != null) {
                this._defaultMapping.destroyResource();
            }
            this.destroyWebResources(this._exactMatches);
            this.destroyWebResources(this._extensions);
            this.destroyWebResources(this._urlTree);
        }

        private void destroyWebResources(Map map) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof WebResourceMapping) {
                    WebResourceMapping webResourceMapping = (WebResourceMapping)o;
                    webResourceMapping.destroyResource();
                    continue;
                }
                this.destroyWebResources((Map)o);
            }
        }

        void autoLoadServlets() {
            ArrayList<WebResourceConfiguration> autoLoadable = new ArrayList<WebResourceConfiguration>();
            if (this._defaultMapping != null && this._defaultMapping.getConfiguration().isLoadOnStartup()) {
                autoLoadable.add(this._defaultMapping.getConfiguration());
            }
            this.collectAutoLoadableServlets(autoLoadable, this._exactMatches);
            this.collectAutoLoadableServlets(autoLoadable, this._extensions);
            this.collectAutoLoadableServlets(autoLoadable, this._urlTree);
            if (autoLoadable.isEmpty()) {
                return;
            }
            Collections.sort(autoLoadable, new Comparator(this){
                private final /* synthetic */ WebResourceMap this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    ServletConfiguration sc1 = (ServletConfiguration)o1;
                    ServletConfiguration sc2 = (ServletConfiguration)o2;
                    return sc1.getLoadOrder() <= sc2.getLoadOrder() ? -1 : 1;
                }
            });
            Iterator iterator = autoLoadable.iterator();
            while (iterator.hasNext()) {
                ServletConfiguration servletConfiguration = (ServletConfiguration)iterator.next();
                try {
                    servletConfiguration.getServlet();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException("Unable to autoload servlet: " + servletConfiguration.getClassName() + ": " + e);
                }
            }
        }

        private void collectAutoLoadableServlets(Collection collection, Map map) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o instanceof WebResourceMapping) {
                    WebResourceMapping servletMapping = (WebResourceMapping)o;
                    if (!servletMapping.getConfiguration().isLoadOnStartup()) continue;
                    collection.add(servletMapping.getConfiguration());
                    continue;
                }
                this.collectAutoLoadableServlets(collection, (Map)o);
            }
        }

        private WebResourceMapping getMapping(String url) {
            if (this._exactMatches.containsKey(url)) {
                return (WebResourceMapping)this._exactMatches.get(url);
            }
            Map context = this.getContextForLongestPathPrefix(url);
            if (context.containsKey("*")) {
                return (WebResourceMapping)context.get("*");
            }
            if (this._extensions.containsKey(this.getExtension(url))) {
                return (WebResourceMapping)this._extensions.get(this.getExtension(url));
            }
            if (this._urlTree.containsKey("/")) {
                return (WebResourceMapping)this._urlTree.get("/");
            }
            if (this._defaultMapping != null) {
                return this._defaultMapping;
            }
            String prefix = "/servlet/";
            if (!url.startsWith("/servlet/")) {
                return null;
            }
            String className = url.substring("/servlet/".length());
            try {
                Class.forName(className);
                return new WebResourceMapping(new ServletConfiguration(className));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private Map getContextForLongestPathPrefix(String url) {
            Map context = this._urlTree;
            ParsedPath path = new ParsedPath(url);
            while (path.hasNext()) {
                String part = path.next();
                if (!context.containsKey(part)) break;
                context = (Map)context.get(part);
            }
            return context;
        }

        private String getExtension(String url) {
            int index = url.lastIndexOf(46);
            if (index == -1 || index >= url.length() - 1) {
                return "";
            }
            return url.substring(index + 1);
        }
    }

    static class PartialMatchWebResourceMapping
    extends WebResourceMapping {
        private String _prefix;

        public PartialMatchWebResourceMapping(WebResourceConfiguration configuration, String prefix) {
            super(configuration);
            if (!prefix.endsWith("/*")) {
                throw new IllegalArgumentException(prefix + " does not end with '/*'");
            }
            this._prefix = prefix.substring(0, prefix.length() - 2);
        }

        String getServletPath(String requestPath) {
            return this._prefix;
        }

        String getPathInfo(String requestPath) {
            return requestPath.length() > this._prefix.length() ? requestPath.substring(this._prefix.length()) : null;
        }
    }

    static class WebResourceMapping {
        private WebResourceConfiguration _configuration;

        WebResourceConfiguration getConfiguration() {
            return this._configuration;
        }

        WebResourceMapping(WebResourceConfiguration configuration) {
            this._configuration = configuration;
        }

        String getServletPath(String requestPath) {
            return requestPath;
        }

        String getPathInfo(String requestPath) {
            return null;
        }

        public void destroyResource() {
            this.getConfiguration().destroyResource();
        }
    }

    static class ServletRequestImpl
    implements ServletMetaData {
        private URL _url;
        private String _fullServletPath;
        private WebResourceMapping _mapping;
        private Hashtable _filtersPerName;
        private FilterUrlMap _filtersPerUrl;

        ServletRequestImpl(URL url, String servletPath, WebResourceMapping mapping, Hashtable filtersPerName, FilterUrlMap filtersPerUrl) {
            this._url = url;
            this._fullServletPath = servletPath;
            this._mapping = mapping;
            this._filtersPerName = filtersPerName;
            this._filtersPerUrl = filtersPerUrl;
        }

        public Servlet getServlet() throws ServletException {
            if (this.getConfiguration() == null) {
                throw new HttpNotFoundException("No servlet mapping defined", this._url);
            }
            try {
                return this.getConfiguration().getServlet();
            }
            catch (ClassNotFoundException e) {
                throw new HttpNotFoundException(this._url, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
            catch (ClassCastException e) {
                throw new HttpInternalErrorException(this._url, (Throwable)e);
            }
        }

        public String getServletPath() {
            return this._mapping == null ? null : this._mapping.getServletPath(this._fullServletPath);
        }

        public String getPathInfo() {
            return this._mapping == null ? null : this._mapping.getPathInfo(this._fullServletPath);
        }

        public FilterMetaData[] getFilters() {
            if (this.getConfiguration() == null) {
                return NO_FILTERS;
            }
            ArrayList filters = new ArrayList();
            this.addFiltersForPath(filters, this._fullServletPath);
            this.addFiltersForServletWithName(filters, this.getConfiguration().getServletName());
            return filters.toArray(new FilterMetaData[filters.size()]);
        }

        private void addFiltersForPath(List filters, String fullServletPath) {
            FilterMetaData[] matches = this._filtersPerUrl.getMatchingFilters(fullServletPath);
            int i = 0;
            while (i < matches.length) {
                filters.add(matches[i]);
                ++i;
            }
        }

        private void addFiltersForServletWithName(List filters, String servletName) {
            if (servletName == null) {
                return;
            }
            List matches = (List)this._filtersPerName.get(servletName);
            if (matches != null) {
                filters.addAll(matches);
            }
        }

        private ServletConfiguration getConfiguration() {
            return this._mapping == null ? null : (ServletConfiguration)this._mapping.getConfiguration();
        }
    }

    static class SecurityConstraintImpl
    implements SecurityConstraint {
        private String[] _roles;
        private ArrayList _roleList = new ArrayList();
        private ArrayList _resources = new ArrayList();

        SecurityConstraintImpl(Element root) throws SAXException {
            NodeList roleNames = root.getElementsByTagName("role-name");
            int i = 0;
            while (i < roleNames.getLength()) {
                this._roleList.add(XMLUtils.getTextValue(roleNames.item(i)));
                ++i;
            }
            NodeList resources = root.getElementsByTagName("web-resource-collection");
            int i2 = 0;
            while (i2 < resources.getLength()) {
                this._resources.add(new WebResourceCollection((Element)resources.item(i2)));
                ++i2;
            }
        }

        public boolean controlsPath(String urlPath) {
            return this.getMatchingCollection(urlPath) != null;
        }

        public String[] getPermittedRoles() {
            if (this._roles == null) {
                this._roles = this._roleList.toArray(new String[this._roleList.size()]);
            }
            return this._roles;
        }

        public WebResourceCollection getMatchingCollection(String urlPath) {
            Iterator i = this._resources.iterator();
            while (i.hasNext()) {
                WebResourceCollection wrc = (WebResourceCollection)i.next();
                if (!wrc.controlsPath(urlPath)) continue;
                return wrc;
            }
            return null;
        }

        class WebResourceCollection {
            private ArrayList _urlPatterns = new ArrayList();

            WebResourceCollection(Element root) throws SAXException {
                NodeList urlPatterns = root.getElementsByTagName("url-pattern");
                int i = 0;
                while (i < urlPatterns.getLength()) {
                    this._urlPatterns.add(XMLUtils.getTextValue(urlPatterns.item(i)));
                    ++i;
                }
            }

            boolean controlsPath(String urlPath) {
                Iterator i = this._urlPatterns.iterator();
                while (i.hasNext()) {
                    String pattern = (String)i.next();
                    if (!WebApplication.patternMatches(pattern, urlPath)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    static class NullSecurityConstraint
    implements SecurityConstraint {
        private static final String[] NO_ROLES = new String[0];

        NullSecurityConstraint() {
        }

        public boolean controlsPath(String urlPath) {
            return false;
        }

        public String[] getPermittedRoles() {
            return NO_ROLES;
        }
    }

    static interface SecurityConstraint {
        public boolean controlsPath(String var1);

        public String[] getPermittedRoles();
    }

    class FilterConfiguration
    extends WebResourceConfiguration
    implements FilterMetaData {
        private Filter _filter;
        private String _name;

        FilterConfiguration(String name, Element filterElement) throws SAXException {
            super(filterElement, "filter-class");
            this._name = name;
        }

        public synchronized Filter getFilter() throws ServletException {
            try {
                if (this._filter == null) {
                    Class<?> filterClass = Class.forName(this.getClassName());
                    this._filter = (Filter)filterClass.newInstance();
                    this._filter.init((FilterConfig)new FilterConfigImpl(this._name, WebApplication.this.getServletContext(), this.getInitParams()));
                }
                return this._filter;
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Did not find filter class: " + this.getClassName());
            }
            catch (IllegalAccessException e) {
                throw new ServletException("Filter class " + this.getClassName() + " lacks a public no-arg constructor");
            }
            catch (InstantiationException e) {
                throw new ServletException("Filter class " + this.getClassName() + " instantiation threw" + e.getCause());
            }
            catch (ClassCastException e) {
                throw new ServletException("Filter class " + this.getClassName() + " does not implement" + (class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = WebApplication.class$("javax.servlet.Filter")) : class$javax$servlet$Filter).getName());
            }
        }

        boolean isLoadOnStartup() {
            return false;
        }

        synchronized void destroyResource() {
            if (this._filter != null) {
                this._filter.destroy();
            }
        }
    }

    class ServletConfiguration
    extends WebResourceConfiguration {
        private Servlet _servlet;
        private String _servletName;
        private int _loadOrder = Integer.MIN_VALUE;

        ServletConfiguration(String className) {
            super(className);
        }

        ServletConfiguration(String className, Hashtable initParams) {
            super(className, initParams);
        }

        ServletConfiguration(Element servletElement) throws SAXException {
            super(servletElement, "servlet-class");
            this._servletName = XMLUtils.getChildNodeValue(servletElement, "servlet-name");
            NodeList loadOrder = servletElement.getElementsByTagName("load-on-startup");
            int i = 0;
            while (i < loadOrder.getLength()) {
                String order = XMLUtils.getTextValue(loadOrder.item(i));
                try {
                    this._loadOrder = Integer.parseInt(order);
                }
                catch (NumberFormatException e) {
                    this._loadOrder = Integer.MAX_VALUE;
                }
                ++i;
            }
        }

        synchronized Servlet getServlet() throws ClassNotFoundException, InstantiationException, IllegalAccessException, ServletException {
            if (this._servlet == null) {
                Class<?> servletClass = Class.forName(this.getClassName());
                this._servlet = (Servlet)servletClass.newInstance();
                String servletName = this._servletName != null ? this._servletName : this._servlet.getClass().getName();
                this._servlet.init((ServletConfig)new ServletUnitServletConfig(servletName, WebApplication.this, this.getInitParams()));
            }
            return this._servlet;
        }

        synchronized void destroyResource() {
            if (this._servlet != null) {
                this._servlet.destroy();
            }
        }

        String getServletName() {
            return this._servletName;
        }

        boolean isLoadOnStartup() {
            return this._loadOrder != Integer.MIN_VALUE;
        }

        public int getLoadOrder() {
            return this._loadOrder;
        }
    }

    static class SecurityCheckServlet
    extends HttpServlet {
        SecurityCheckServlet() {
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.handleLogin(req, resp);
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.handleLogin(req, resp);
        }

        private void handleLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            String username = req.getParameter("j_username");
            String roleList = req.getParameter("j_password");
            this.getServletSession(req).setUserInformation(username, ServletUnitHttpRequest.toArray(roleList));
            resp.sendRedirect(this.getServletSession(req).getOriginalURL().toExternalForm());
        }

        private ServletUnitHttpSession getServletSession(HttpServletRequest req) {
            return (ServletUnitHttpSession)req.getSession();
        }
    }
}

