/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BinaryXMLEncoder
extends DefaultHandler {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLEncoder.class);
    public static final int ELEMENT_START_TAG = 1;
    public static final int EMPTY_ELEMENT_TAG = 2;
    public static final int ATTRIBUTE_TAG = 3;
    public static final int TEXT_TAG = 4;
    public static final int PREFIXMAPPING_TAG = 5;
    public static final int ELEMENT_END_TAG = 9;
    public static final int NONE_MASK = 0;
    public static final int INDEXED_MASK = 16;
    public static final int NS_MASK = 32;
    public static final int TEXT_TERMINATOR = 0;
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private List nameList = new ArrayList();
    private Map nameMap = new HashMap();
    private Map prefixMap = new HashMap();
    private int prefixIndex = 0;
    private Element current;
    private String textEncoding = "UTF-8";

    public BinaryXMLEncoder(String textEncoding) {
        if (textEncoding != null) {
            this.textEncoding = textEncoding;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            log.debug((Object)("*start element:" + qName));
            log.debug((Object)("*attributes:" + attributes.getLength()));
            if (this.current != null) {
                this.current.writeStartTag();
            }
            this.current = new Element(uri, localName, qName, attributes);
        }
        catch (IOException e) {
            log.fatal((Object)e.toString(), (Throwable)e);
            throw new SAXException(e);
        }
        catch (RuntimeException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            log.debug((Object)("*end element:" + qName));
            if (this.current != null) {
                this.current.writeEmptyTag();
                this.current = null;
            } else {
                this.out.write(9);
            }
        }
        catch (IOException e) {
            log.fatal((Object)e.toString(), (Throwable)e);
            throw new SAXException(e);
        }
        catch (RuntimeException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw e;
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        try {
            String text;
            if (this.current != null) {
                this.current.writeStartTag();
                this.current = null;
            }
            if (Pattern.matches("^[\\s]*$", text = new String(ch, start, len))) {
                return;
            }
            this.out.write(4);
            this.out.write(this.toVariableLengthText(text));
            this.out.write(0);
            log.debug((Object)("*charactor[" + start + "][" + len + "]: " + new String(ch, start, len)));
        }
        catch (IOException e) {
            log.fatal((Object)e.toString(), (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            PrefixMapping pm = (PrefixMapping)this.prefixMap.get(prefix);
            if (pm == null) {
                pm = new PrefixMapping(prefix);
                this.prefixMap.put(prefix, pm);
            }
            pm.addUri(uri);
            int indexed = prefix.length() == 0 ? 0 : 16;
            this.out.write(indexed | 5);
            if (indexed == 16) {
                this.out.write(this.toVariableLengthNumber(pm.getIndex()));
                this.out.write(this.toVariableLengthText(prefix));
                this.out.write(0);
            }
            this.out.write(this.toVariableLengthText(uri));
            this.out.write(0);
            log.debug((Object)("*start prefix mapping[" + pm.getIndex() + "]: " + prefix + "=" + uri));
        }
        catch (IOException e) {
            log.fatal((Object)e.toString(), (Throwable)e);
            throw new SAXException(e);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        PrefixMapping pm = (PrefixMapping)this.prefixMap.get(prefix);
        if (pm == null) {
            throw new SAXException("Illegal prefix mapping: " + prefix);
        }
        pm.disposeCurrentUri();
        log.debug((Object)("*end prefix mapping[" + pm.getIndex() + "]: " + prefix));
    }

    public void writeTo(OutputStream os) throws IOException {
        log.debug((Object)("size: " + this.out.size()));
        os.write(this.toVariableLengthNumber(this.out.size()));
        log.debug((Object)("dic-size: " + this.nameMap.size()));
        os.write(this.toVariableLengthNumber(this.nameMap.size()));
        os.write(this.toVariableLengthText("1.0"));
        os.write(0);
        os.write(this.toVariableLengthText(this.textEncoding));
        os.write(0);
        for (int i = 0; i < this.nameList.size(); ++i) {
            String name = (String)this.nameList.get(i);
            os.write(this.toVariableLengthNumber(i + 1));
            os.write(this.toVariableLengthText(name));
            os.write(0);
            log.debug((Object)("dic entry: " + (i + 1) + " = " + name));
        }
        os.write(this.out.toByteArray());
    }

    private SortedSet createSortedEntries() {
        TreeSet set = new TreeSet(new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Map.Entry entry1 = (Map.Entry)obj1;
                Map.Entry entry2 = (Map.Entry)obj2;
                return ((Integer)entry1.getValue()).compareTo((Integer)entry2.getValue());
            }
        });
        set.addAll(this.nameMap.entrySet());
        return set;
    }

    private byte[] toVariableLengthNumber(int i) throws UnsupportedEncodingException {
        return String.valueOf((char)i).getBytes("UTF-8");
    }

    private byte[] toVariableLengthText(String text) throws UnsupportedEncodingException {
        return text.getBytes(this.textEncoding);
    }

    private boolean contains(String name) {
        return this.nameMap.containsKey(name);
    }

    private int getNameIndexOf(String name) {
        Integer index = (Integer)this.nameMap.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    private void registName(String name) {
        if (name.length() < 3) {
            return;
        }
        if (this.nameMap.get(name) != null) {
            return;
        }
        this.nameList.add(name);
        this.nameMap.put(name, new Integer(this.nameList.size()));
    }

    private int getPrefixIndexOf(String prefix) {
        PrefixMapping pm = (PrefixMapping)this.prefixMap.get(prefix);
        if (pm == null) {
            return "".equals(prefix) ? 0 : -1;
        }
        return pm.getIndex();
    }

    class PrefixMapping {
        private String prefix;
        private List list = new ArrayList();
        private int index = 0;

        PrefixMapping(String prefix) {
            this.prefix = prefix;
            if (prefix.length() == 0) {
                return;
            }
            this.index = ++BinaryXMLEncoder.this.prefixIndex;
        }

        void addUri(String uri) {
            this.list.add(uri);
        }

        String getCurrentUri() {
            if (this.list.size() == 0) {
                return null;
            }
            return (String)this.list.get(this.list.size() - 1);
        }

        String disposeCurrentUri() {
            if (this.list.size() == 0) {
                return null;
            }
            return (String)this.list.remove(this.list.size() - 1);
        }

        int getIndex() {
            return this.index;
        }
    }

    class Attribute
    extends Node {
        private String value;

        Attribute(String localName, String qName, String value) {
            super(localName, qName);
            this.localName = localName;
            this.qName = qName;
            this.value = value;
            BinaryXMLEncoder.this.registName(localName);
        }

        void writeAttibute() throws IOException {
            int n = this.prefix == null || this.prefix.length() == 0 ? 0 : 32;
            int i = BinaryXMLEncoder.this.contains(this.localName) ? 0 : 16;
            BinaryXMLEncoder.this.out.write(3 | n | i);
            log.debug((Object)"write attribute ...");
            log.debug((Object)("tag header: " + Integer.toHexString(3 | n | i)));
            this.writeNSIndex();
            this.writeName();
            this.writeValue(this.value);
        }
    }

    class Element
    extends Node {
        private String uri;
        private List attributes;

        Element(String uri, String localName, String qName, Attributes attributes) {
            super(localName, qName);
            this.attributes = new ArrayList();
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            BinaryXMLEncoder.this.registName(localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                log.debug((Object)("attributes[" + i + "]: localName=" + attributes.getLocalName(i) + ", QName=" + attributes.getQName(i)));
                if (attributes.getQName(i).equals("xmlns") || attributes.getQName(i).startsWith("xmlns:")) continue;
                this.attributes.add(new Attribute(attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i)));
            }
            log.debug((Object)("create element: localName=" + localName + ", QName=" + qName));
            log.debug((Object)("attributes[" + this.attributes + "]: " + this.attributes.size()));
        }

        void writeStartTag() throws IOException {
            log.debug((Object)"write start tag...");
            this.writeTagHeader(false);
            this.writeName();
            this.writeAttributes();
        }

        void writeEmptyTag() throws IOException {
            log.debug((Object)"write empty tag...");
            this.writeTagHeader(true);
            this.writeName();
            this.writeAttributes();
        }

        private void writeTagHeader(boolean empty) throws IOException {
            int n = this.prefix == null || this.prefix.length() == 0 ? 0 : 32;
            int i = BinaryXMLEncoder.this.contains(this.localName) ? 0 : 16;
            int e = !empty ? 1 : 2;
            BinaryXMLEncoder.this.out.write(n | i | e);
            log.debug((Object)("write header: " + Integer.toHexString(n | i | e)));
            this.writeNSIndex();
        }

        private void writeAttributes() throws IOException {
            log.debug((Object)"write attributes");
            log.debug((Object)("attributes[" + this.attributes + "]: " + this.attributes.size()));
            for (int i = 0; i < this.attributes.size(); ++i) {
                Attribute attr = (Attribute)this.attributes.get(i);
                attr.writeAttibute();
            }
        }
    }

    abstract class Node {
        protected String localName;
        protected String qName;
        protected String prefix;

        Node(String localName, String qName) {
            this.localName = localName;
            this.qName = qName;
            if (localName.length() == 0) {
                return;
            }
            this.prefix = localName.equals(qName) ? "" : qName.substring(0, qName.indexOf(58));
        }

        protected void writeName() throws IOException {
            int index = BinaryXMLEncoder.this.getNameIndexOf(this.localName);
            if (index > 0) {
                BinaryXMLEncoder.this.out.write(BinaryXMLEncoder.this.toVariableLengthNumber(index));
                log.debug((Object)("write name: " + index + " as " + this.localName));
            } else {
                BinaryXMLEncoder.this.out.write(BinaryXMLEncoder.this.toVariableLengthText(this.localName));
                BinaryXMLEncoder.this.out.write(0);
                log.debug((Object)("write name: " + this.localName));
            }
        }

        protected void writeValue(String value) throws IOException {
            BinaryXMLEncoder.this.out.write(BinaryXMLEncoder.this.toVariableLengthText(value));
            BinaryXMLEncoder.this.out.write(0);
            log.debug((Object)("write value: " + value));
        }

        protected void writeNSIndex() throws IOException {
            if (this.prefix == null || this.prefix.length() == 0) {
                return;
            }
            int index = BinaryXMLEncoder.this.getPrefixIndexOf(this.prefix);
            BinaryXMLEncoder.this.out.write(BinaryXMLEncoder.this.toVariableLengthNumber(index));
            log.debug((Object)("write ns: " + index + " as " + this.prefix));
        }

        protected String getPrefix() {
            return this.qName.substring(0, this.qName.indexOf(58));
        }
    }
}

