/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.framework.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.haw.grain.framework.xml.BinaryXMLEncoder;
import jp.haw.grain.framework.xml.ParseException;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BinaryXMLOutputter {
    private static final Logger log = Logger.getLogger((Class)BinaryXMLOutputter.class);
    private InputSource source;
    private String encoding;
    private String lineSeparator = "\n";

    public BinaryXMLOutputter(byte[] bs) {
        this.source = new InputSource(new ByteArrayInputStream(bs));
    }

    public BinaryXMLOutputter(char[] cs) {
        this.source = new InputSource(new CharArrayReader(cs));
        String head = new String(cs, 0, cs.length > 50 ? 50 : cs.length);
        this.parseEncoding(head);
    }

    public BinaryXMLOutputter(InputStream is) {
        this.source = new InputSource(is);
    }

    public BinaryXMLOutputter(Reader reader) {
        this.source = new InputSource(reader);
    }

    public BinaryXMLOutputter(String src) {
        this.source = new InputSource(new StringReader(src));
        this.parseEncoding(src);
    }

    private void parseEncoding(String head) {
        if (!head.startsWith("<?xml")) {
            return;
        }
        Matcher m = Pattern.compile("encoding=\"([^\"]*)\"").matcher(head);
        if (m.find() && m.groupCount() > 0) {
            this.setTextEncoding(m.group(1));
        }
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setTextEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void writeTo(OutputStream os) throws IOException, ParseException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            log.debug((Object)("SAXParser: " + parser.getClass().getName()));
            log.debug((Object)("char stream: " + this.source.getCharacterStream()));
            log.debug((Object)("output stream: " + os.getClass().getName()));
            BinaryXMLEncoder enc = new BinaryXMLEncoder(this.encoding);
            parser.parse(this.source, (DefaultHandler)enc);
            enc.writeTo(os);
        }
        catch (SAXException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
        catch (ParserConfigurationException e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
        catch (FactoryConfigurationError e) {
            log.debug((Object)e.toString(), (Throwable)e);
            throw new ParseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block30: {
            Object v0;
            if (args.length != 3) {
                System.err.println("ussage: encoding infile(xml) outfile(gbxml)");
                System.exit(1);
            }
            BufferedInputStream is = null;
            OutputStream os = null;
            is = new BufferedInputStream(new FileInputStream(args[1]));
            BinaryXMLOutputter bxo = new BinaryXMLOutputter(is);
            bxo.setTextEncoding(args[0]);
            os = new BufferedOutputStream(new FileOutputStream(args[2]));
            bxo.writeTo(os);
            Object var5_6 = null;
            try {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    v0 = null;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    v0 = null;
                }
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var8_18 = v0;
            try {
                if (os != null) {
                    os.close();
                }
                break block30;
            }
            catch (IOException ie) {
                ie.printStackTrace();
            }
            break block30;
            {
                catch (IOException e) {
                    Object v1;
                    e.printStackTrace();
                    Object var5_7 = null;
                    try {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            v1 = null;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                            v1 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var8_19 = v1;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block30;
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                    break block30;
                }
                catch (ParseException e) {
                    Object v2;
                    e.printStackTrace();
                    Object var5_8 = null;
                    try {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            v2 = null;
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                            v2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var8_20 = v2;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block30;
                    }
                    catch (IOException ie) {
                        ie.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var5_9 = null;
                try {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        v3 = null;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        v3 = null;
                    }
                }
                catch (Throwable throwable2) {
                    v3 = null;
                }
                Object var8_21 = v3;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ie) {
                    ie.printStackTrace();
                }
                throw throwable;
            }
        }
    }
}

