/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.jetty.Jetty4xEmbeddedContainer;
import org.codehaus.cargo.container.jo.Jo1xContainer;
import org.codehaus.cargo.container.orion.Oc4j9xContainer;
import org.codehaus.cargo.container.orion.Orion1xContainer;
import org.codehaus.cargo.container.orion.Orion2xContainer;
import org.codehaus.cargo.container.resin.Resin2xContainer;
import org.codehaus.cargo.container.resin.Resin3xContainer;
import org.codehaus.cargo.container.tomcat.Tomcat3xContainer;
import org.codehaus.cargo.container.tomcat.Tomcat4xContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xContainer;
import org.codehaus.cargo.container.weblogic.WebLogic8xContainer;

public class ContainerFactory {
    private Map containerNames = new HashMap();

    public ContainerFactory() {
        this.containerNames.put("resin2x", Resin2xContainer.class);
        this.containerNames.put("resin3x", Resin3xContainer.class);
        this.containerNames.put("orion1x", Orion1xContainer.class);
        this.containerNames.put("orion2x", Orion2xContainer.class);
        this.containerNames.put("oc4j9x", Oc4j9xContainer.class);
        this.containerNames.put("jetty4xEmbedded", Jetty4xEmbeddedContainer.class);
        this.containerNames.put("tomcat3x", Tomcat3xContainer.class);
        this.containerNames.put("tomcat4x", Tomcat4xContainer.class);
        this.containerNames.put("tomcat5x", Tomcat5xContainer.class);
        this.containerNames.put("weblogic8x", WebLogic8xContainer.class);
        this.containerNames.put("jo1x", Jo1xContainer.class);
    }

    public ContainerFactory(Map containerNames) {
        this.containerNames.putAll(containerNames);
    }

    public Container createContainer(String key) {
        Container container;
        try {
            Class containerClass = this.containerNames.containsKey(key) ? (Class)this.containerNames.get(key) : Class.forName(key);
            Constructor constructor = containerClass.getConstructor(new Class[0]);
            container = (Container)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to instantiate container for key [" + key + "]", e);
        }
        return container;
    }
}

