/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.configuration;

import java.io.File;
import java.lang.reflect.Constructor;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationFactory;
import org.codehaus.cargo.container.jetty.JettyStandaloneConfiguration;
import org.codehaus.cargo.container.jo.Jo1xStandaloneConfiguration;
import org.codehaus.cargo.container.orion.OrionStandaloneConfiguration;
import org.codehaus.cargo.container.resin.Resin2xStandaloneConfiguration;
import org.codehaus.cargo.container.resin.Resin3xStandaloneConfiguration;
import org.codehaus.cargo.container.spi.AbstractGenericHintFactory;
import org.codehaus.cargo.container.tomcat.CatalinaStandaloneConfiguration;
import org.codehaus.cargo.container.tomcat.TomcatStandaloneConfiguration;
import org.codehaus.cargo.container.weblogic.WebLogicStandaloneConfiguration;

public class DefaultConfigurationFactory
extends AbstractGenericHintFactory
implements ConfigurationFactory {
    public DefaultConfigurationFactory() {
        this.registerImplementation("resin2x", "standalone", Resin2xStandaloneConfiguration.class);
        this.registerImplementation("resin3x", "standalone", Resin3xStandaloneConfiguration.class);
        this.registerImplementation("orion1x", "standalone", OrionStandaloneConfiguration.class);
        this.registerImplementation("orion2x", "standalone", OrionStandaloneConfiguration.class);
        this.registerImplementation("tomcat3x", "standalone", TomcatStandaloneConfiguration.class);
        this.registerImplementation("tomcat4x", "standalone", CatalinaStandaloneConfiguration.class);
        this.registerImplementation("tomcat5x", "standalone", CatalinaStandaloneConfiguration.class);
        this.registerImplementation("jetty4xEmbedded", "standalone", JettyStandaloneConfiguration.class);
        this.registerImplementation("weblogic8x", "standalone", WebLogicStandaloneConfiguration.class);
        this.registerImplementation("oc4j9x", "standalone", OrionStandaloneConfiguration.class);
        this.registerImplementation("jo1x", "standalone", Jo1xStandaloneConfiguration.class);
    }

    public void registerConfiguration(String containerId, String hint, Class configurationClass) {
        this.registerImplementation(containerId, hint, configurationClass);
    }

    public Configuration createConfiguration(Container container, String hint) {
        return this.createConfiguration(container, hint, null);
    }

    public Configuration createConfiguration(Container container, String hint, File homeDir) {
        ConfigurationFactoryParameters parameters = new ConfigurationFactoryParameters();
        parameters.homeDir = homeDir;
        return (Configuration)this.createImplementation(container, hint, parameters, "configuration");
    }

    protected Constructor getConstructor(Class configurationClass, AbstractGenericHintFactory.GenericParameters parameters) throws NoSuchMethodException {
        File homeDir = ((ConfigurationFactoryParameters)parameters).homeDir;
        Constructor constructor = homeDir == null ? configurationClass.getConstructor(Container.class) : configurationClass.getConstructor(Container.class, File.class);
        return constructor;
    }

    protected Object createInstance(Constructor constructor, Container container, AbstractGenericHintFactory.GenericParameters parameters) throws Exception {
        File homeDir = ((ConfigurationFactoryParameters)parameters).homeDir;
        Configuration configuration = homeDir == null ? (Configuration)constructor.newInstance(container) : (Configuration)constructor.newInstance(container, homeDir);
        return configuration;
    }

    private static class ConfigurationFactoryParameters
    implements AbstractGenericHintFactory.GenericParameters {
        public File homeDir;

        private ConfigurationFactoryParameters() {
        }
    }
}

