/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class FileUtils {
    private static int uniqueNameCounter = -1;

    public final File createDirectory(File theParentDir, String theName) throws IOException {
        File dir = new File(theParentDir, theName);
        dir.mkdirs();
        if (!dir.isDirectory()) {
            throw new IOException("Couldn't create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    public final String getFilename(String filePath) {
        int index = filePath.lastIndexOf(File.separator);
        return index >= 0 ? filePath.substring(index + 1) : filePath;
    }

    public synchronized File createTmpDir() {
        if (uniqueNameCounter == -1) {
            uniqueNameCounter = new Random().nextInt() & 0xFFFF;
        }
        File tmpDir = null;
        while ((tmpDir = new File(new File(System.getProperty("java.io.tmpdir")), "cargo/" + Integer.toString(++uniqueNameCounter))).exists()) {
        }
        tmpDir.deleteOnExit();
        tmpDir.mkdirs();
        return tmpDir;
    }

    public void copy(InputStream in, OutputStream out) throws IOException {
        this.copy(in, out, 1024);
    }

    public void copy(InputStream in, OutputStream out, int bufSize) throws IOException {
        int length;
        byte[] buf = new byte[bufSize];
        while ((length = in.read(buf)) != -1) {
            out.write(buf, 0, length);
        }
    }
}

