/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.server.runner;

import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.internal.server.runner.XMLConstants;
import org.apache.cactus.internal.util.JUnitVersionHelper;
import org.apache.cactus.internal.util.StringUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class XMLFormatter
implements XMLConstants,
TestListener {
    private static final String[] DEFAULT_STACK_FILTER_PATTERNS;
    private String xslFileName;
    private String suiteClassName;
    private long totalDuration;
    private String encoding = "UTF-8";
    private long currentTestStartTime;
    private NumberFormat durationFormat = NumberFormat.getInstance(Locale.US);
    private StringBuffer currentTestCaseResults = new StringBuffer();
    private String currentTestFailure;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;

    static {
        Factory factory = new Factory("XMLFormatter.java", Class.forName("org.apache.cactus.internal.server.runner.XMLFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setXslFileName-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theXslFileName:--void-"), 109);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setEncoding-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theEncoding:--void-"), 117);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setSuiteClassName-org.apache.cactus.internal.server.runner.XMLFormatter-java.lang.String:-theSuiteClassName:--void-"), 143);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTotalDuration-org.apache.cactus.internal.server.runner.XMLFormatter-long:-theDuration:--void-"), 172);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toXML-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.TestResult:-theResult:--java.lang.String-"), 183);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-startTest-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 218);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addError-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:java.lang.Throwable:-theTest:theThrowable:--void-"), 230);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addFailure-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:junit.framework.AssertionFailedError:-theTest:theError:--void-"), 252);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-endTest-org.apache.cactus.internal.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 273);
        DEFAULT_STACK_FILTER_PATTERNS = new String[]{"org.apache.cactus.AbstractTestCase", "org.apache.cactus.AbstractWebTestCase", "org.apache.cactus.FilterTestCase", "org.apache.cactus.JspTestCase", "org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "java.lang.reflect.Method.invoke("};
    }

    public void setXslFileName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setXslFileName_aroundBody1$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setEncoding(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setEncoding_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String string) {
        String string2 = string;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string2);
        XMLFormatter.setSuiteClassName_aroundBody5$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getTotalDurationAsString() {
        return this.getDurationAsString(this.totalDuration);
    }

    private String getDurationAsString(long theDuration) {
        return this.durationFormat.format((double)theDuration / 1000.0);
    }

    public void setTotalDuration(long l) {
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        XMLFormatter.setTotalDuration_aroundBody7$advice(this, l2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toXML(TestResult testResult) {
        TestResult testResult2 = testResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)testResult2);
        return (String)XMLFormatter.toXML_aroundBody9$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void startTest(Test test) {
        Test test2 = test;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)test2);
        XMLFormatter.startTest_aroundBody11$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addError(Test test, Throwable throwable) {
        Test test2 = test;
        Throwable throwable2 = throwable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)test2, (Object)throwable2);
        XMLFormatter.addError_aroundBody13$advice(this, test2, throwable2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        Test test2 = test;
        AssertionFailedError assertionFailedError2 = assertionFailedError;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)test2, (Object)assertionFailedError2);
        XMLFormatter.addFailure_aroundBody15$advice(this, test2, assertionFailedError2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void endTest(Test test) {
        Test test2 = test;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)test2);
        XMLFormatter.endTest_aroundBody17$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String xmlEncode(String theString) {
        String newString = StringUtil.replace(theString, '&', "&amp;");
        newString = StringUtil.replace(newString, '<', "&lt;");
        newString = StringUtil.replace(newString, '>', "&gt;");
        newString = StringUtil.replace(newString, '\"', "&quot;");
        return newString;
    }

    private static final void setXslFileName_aroundBody0(XMLFormatter xMLFormatter, String string, JoinPoint joinPoint) {
        xMLFormatter.xslFileName = string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setXslFileName_aroundBody1$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.setXslFileName_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.setXslFileName_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setEncoding_aroundBody2(XMLFormatter xMLFormatter, String string, JoinPoint joinPoint) {
        xMLFormatter.encoding = string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setEncoding_aroundBody3$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.setEncoding_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.setEncoding_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setSuiteClassName_aroundBody4(XMLFormatter xMLFormatter, String string, JoinPoint joinPoint) {
        xMLFormatter.suiteClassName = string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setSuiteClassName_aroundBody5$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.setSuiteClassName_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.setSuiteClassName_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void setTotalDuration_aroundBody6(XMLFormatter xMLFormatter, long l, JoinPoint joinPoint) {
        xMLFormatter.totalDuration = l;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object setTotalDuration_aroundBody7$advice(XMLFormatter this_, long ajc_aroundClosure, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.setTotalDuration_aroundBody6(this_, ajc_aroundClosure, (JoinPoint)target);
            Object var9_9 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_9;
        }
        void var11_10 = result;
        XMLFormatter.setTotalDuration_aroundBody6(this_, ajc_aroundClosure, (JoinPoint)target);
        return null;
    }

    private static final String toXML_aroundBody8(XMLFormatter xMLFormatter, TestResult testResult, JoinPoint joinPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + xMLFormatter.getEncoding() + "\"?>");
        if (xMLFormatter.xslFileName != null) {
            stringBuffer.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + xMLFormatter.xslFileName + "\"?>");
        }
        stringBuffer.append("<testsuites>");
        stringBuffer.append("<testsuite name=\"" + xMLFormatter.getSuiteClassName() + "\" " + "tests" + "=\"" + testResult.runCount() + "\" " + "failures" + "=\"" + testResult.failureCount() + "\" " + "errors" + "=\"" + testResult.errorCount() + "\" " + "time" + "=\"" + xMLFormatter.getTotalDurationAsString() + "\">");
        stringBuffer.append(xMLFormatter.currentTestCaseResults.toString());
        stringBuffer.append("</testsuite>");
        stringBuffer.append("</testsuites>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Object toXML_aroundBody9$advice(XMLFormatter this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = XMLFormatter.toXML_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return XMLFormatter.toXML_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
    }

    private static final void startTest_aroundBody10(XMLFormatter xMLFormatter, Test test, JoinPoint joinPoint) {
        xMLFormatter.currentTestStartTime = System.currentTimeMillis();
        xMLFormatter.currentTestFailure = null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object startTest_aroundBody11$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.startTest_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.startTest_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    private static final void addError_aroundBody12(XMLFormatter xMLFormatter, Test test, Throwable throwable, JoinPoint joinPoint) {
        TestFailure testFailure = new TestFailure(test, throwable);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<error message=\"" + xMLFormatter.xmlEncode(testFailure.thrownException().getMessage()) + "\" " + "type" + "=\"" + testFailure.thrownException().getClass().getName() + "\">");
        stringBuffer.append(xMLFormatter.xmlEncode(StringUtil.exceptionToString(testFailure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        stringBuffer.append("</error>");
        xMLFormatter.currentTestFailure = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Object addError_aroundBody13$advice(XMLFormatter this_, Test ajc_aroundClosure, Throwable thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addError_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        XMLFormatter.addError_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    private static final void addFailure_aroundBody14(XMLFormatter xMLFormatter, Test test, AssertionFailedError assertionFailedError, JoinPoint joinPoint) {
        TestFailure testFailure = new TestFailure(test, (Throwable)assertionFailedError);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<failure message=\"" + xMLFormatter.xmlEncode(testFailure.thrownException().getMessage()) + "\" " + "type" + "=\"" + testFailure.thrownException().getClass().getName() + "\">");
        stringBuffer.append(xMLFormatter.xmlEncode(StringUtil.exceptionToString(testFailure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        stringBuffer.append("</failure>");
        xMLFormatter.currentTestFailure = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final Object addFailure_aroundBody15$advice(XMLFormatter this_, Test ajc_aroundClosure, AssertionFailedError thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addFailure_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        XMLFormatter.addFailure_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    private static final void endTest_aroundBody16(XMLFormatter xMLFormatter, Test test, JoinPoint joinPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = xMLFormatter.getDurationAsString(System.currentTimeMillis() - xMLFormatter.currentTestStartTime);
        stringBuffer.append("<testcase name=\"" + JUnitVersionHelper.getTestCaseName(test) + "\" " + "time" + "=\"" + string + "\">");
        if (xMLFormatter.currentTestFailure != null) {
            stringBuffer.append(xMLFormatter.currentTestFailure);
        }
        stringBuffer.append("</testcase>");
        xMLFormatter.currentTestCaseResults.append(stringBuffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final Object endTest_aroundBody17$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.endTest_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.endTest_aroundBody16(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

