/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.mortbay.http.HttpMessage;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.Code;

public class NullableOutputStream
extends FilterOutputStream
implements HttpMessage.HeaderWriter {
    private ByteArrayISO8859Writer _httpMessageWriter;
    private boolean _nulled = false;
    private boolean _closed = false;
    private int _headerReserve;

    public NullableOutputStream(OutputStream outputStream, int headerReserve) {
        super(outputStream);
        this._headerReserve = headerReserve;
    }

    public void nullOutput() throws IOException {
        this._nulled = true;
    }

    public boolean isNullOutput() throws IOException {
        return this._nulled;
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        if (this._httpMessageWriter == null) {
            this._httpMessageWriter = new ByteArrayISO8859Writer(this._headerReserve);
        }
        httpMessage.writeHeader(this._httpMessageWriter);
        this._httpMessageWriter.writeTo(this.out);
        this._httpMessageWriter.resetWriter();
    }

    public void resetStream() {
        this._closed = false;
        this._nulled = false;
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.resetWriter();
        }
    }

    public void destroy() {
        if (this._httpMessageWriter != null) {
            this._httpMessageWriter.destroy();
        }
        this._httpMessageWriter = null;
        try {
            this.out.close();
        }
        catch (Exception e) {
            Code.warning(e);
        }
    }

    public void write(int b) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b);
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b, 0, b.length);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this._nulled) {
            if (this._closed) {
                throw new IOException("closed");
            }
            this.out.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        if (!this._nulled && !this._closed) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this._closed = true;
    }
}

