/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/15 8:36:47
 * 
 */
package jp.grain.spike.xpath;

import java.util.Stack;
import java.util.Vector;

import jp.grain.spike.Node;
import jp.grain.sprout.model.Model;
import jp.grain.sprout.ui.ContextNodeset;
import jp.grain.sprout.ui.Form;

/**
 * TODO XPathLocator
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class XPathExpr {

    public static final String NAME = "expr";
    
    private Vector _elements = new Vector();
    private ContextNodeset _contextNodeset;
    private boolean _single;
    
    private Node[] _cache;

    /**
     * @param element
     */
    public void addXPathElement(XPathElement element) {
        _elements.addElement(element);
    }

    /**
     * 
     */
    public Node getNode() {
        if (_cache == null) {
            evaluate();
        }
        if (_cache.length == 0) return null;
        return _cache[0];
    }
    
    public Node[] getNodeset() {
        if (_cache == null) {
            evaluate();
        }
        return _cache;
    }
    
    public void initContext(Form form, String modelId, boolean single) {
        Model contextModel = form.getContextModel(modelId);
        _contextNodeset = contextModel.getContextNodeset();
        _single = single;
    }

    
    /**
     * 
     */
    public String evaluate() {
        int pc = 0;
        Stack stack = new Stack();
        while (pc < _elements.size()) {
            XPathElement elem = (XPathElement)_elements.elementAt(pc);
            pc = elem.execute(_contextNodeset, pc, stack);
        }
        if (stack.peek() instanceof Node[]) {
            Node[] nodeset = (Node[])stack.pop();
            _cache = (_single && nodeset.length > 1) ? new Node[] { nodeset[0] } : nodeset;
            if (_cache.length == 0) return "";
            return _cache[0].toString();
        } else {
            return stack.peek() == null ? "" : String.valueOf(stack.pop());
        }
    }

    /**
     * @return
     */
    public ContextNodeset createContextNodeset() {
        return new ContextNodeset(_contextNodeset.getModel(), _cache);
    }
        
}
