/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2004/11/21
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;

import jp.grain.spike.Node;
import jp.grain.sprout.CommandExecuter;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ui.Font;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;

import com.nttdocomo.ui.Dialog;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.IApplication;

/**
 * Dojap̃AvP[V
 * 
 * @version $Id: GrainApp.java 207 2006-04-07 07:47:25Z go $
 * @author go
 */
public class GrainApp extends IApplication implements CommandExecuter {
	
	public static final int DEFAULT_FORM_LOC_LOCAL = 0;
	public static final int DEFAULT_FORM_LOC_HTTP = 1;
	public static final String BASIC_PREF_URI = "scratchpad:///0;pos=0";
	public static final String DEFAULT_FORM_URI = "scratchpad:///1;pos=0";
	
	private AppMenuPanel _appMenuDialog;
	private BasicPrefPanel _basicPrefDialog;
	
    private int _defaultFormLocation = DEFAULT_FORM_LOC_HTTP;
	private String _defaultFormUrl = "http://sphere2.haw.jp/grain/index.xml";
	private String _defaultContentType = "application/xml";
    
    protected FormContextImpl _context;

    
    public GrainApp() {        
        _context = new FormContextImpl(this);
    }
	/* (non-Javadoc)
	 * @see com.nttdocomo.ui.IApplication#start()
	 */
	public void start() {
        FormBuilder.init();
        Font.setDefaultFont(new FontImpl(com.nttdocomo.ui.Font.getDefaultFont()));
		loadBasicPref();
        _context.initBlankForm();
        try {
            _context.getInitializer().join();
        } catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        _context.requestRefresh();
        _context.requestRender();
		goToDefaultForm();
	}
	
	/**
	 * 
	 */
	public void goToDefaultForm() {
		SerializeOperation ope = null;
		if (_defaultFormLocation == DEFAULT_FORM_LOC_HTTP) {
            ope = _context.createSubmissionOperation(getDefaultFormUrl());
		} else {
			ope = FormStoreOperation.createForLoad(DEFAULT_FORM_URI, _context);
		}
		ope.execute(_context);
		if (ope.hasError()) ope.getError().printStackTrace();
    }

	/**
	 * 
	 */
	public void saveCurrentForm() {
        SerializeOperation ope = FormStoreOperation.createForSave(DEFAULT_FORM_URI, _context.getForm());
        _context.execute(ope);
	}

	/**
	 * 
	 */
	public void openBasicPrefDialog() {
		if (_basicPrefDialog == null) {
			_basicPrefDialog = new BasicPrefPanel(this);
		}
		_basicPrefDialog.init();
		Display.setCurrent(_basicPrefDialog);
	}
	
	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#closeApplicationPreferenceDialog()
	 */
	public void closeBasicPrefDialog() {
		Display.setCurrent(_appMenuDialog);
	}
	
	/**
	 * 
	 */
	public void openApplicationMenu() {
		if (_appMenuDialog == null) {
			_appMenuDialog = new AppMenuPanel(this);
			_appMenuDialog.init();
		}
		Display.setCurrent(_appMenuDialog);
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#closeApplicationMenu()
	 */
	public void closeApplicationMenu() {
		Display.setCurrent(_context);
	}

	/**
     * 
	 * @see jp.haw.grain.sprout.SproutApp#submit(java.lang.String, java.lang.String, com.hp.hpl.sparta.Node)
     * @deprecated
	 */
	public Form submit(String uri, String contentType, Node node) throws IOException {
//		FormSerializeOperation ope = new FormSubmissionOperation(uri, contentType);
//		DocumentManager.execSerializeOperation(ope);
//		return (FormDocument)ope.getFormDocuemnt();
        return null;
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#getDefaultFormUri()
	 */
	public String getDefaultFormUrl() {
		return _defaultFormUrl;
	}
	
	public int getDefaultFormLocation() {
		return _defaultFormLocation;
	}
    
    public String getDefaultContentType() {
        return _defaultContentType;
    }

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#setDefaultFormUrl(java.lang.String)
	 */
	public void setDefaultFormUrl(String defaultFormUrl) {
		_defaultFormUrl = defaultFormUrl;
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#setDefaultFormLocation(int)
	 */
	public void setDefaultFormLocation(int defaultFormLocation) {
		_defaultFormLocation = defaultFormLocation;
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#exitApplication()
	 */
	public void exitApplication() {
		Dialog d = new Dialog(Dialog.DIALOG_YESNO, "mF");
		d.setText("AvI܂B\n낵łH\n");
		int result = d.show();
		if (result == Dialog.BUTTON_YES) terminate();
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#storeBasicPref()
	 */
	public void storeBasicPref() {
	    new BasicPrefStoreOperation().execute(_context);
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.SproutApp#loadBasicPref()
	 */
	public void loadBasicPref() {
	    new BasicPrefLoadOperation().execute(_context);
	}
	
	class BasicPrefStoreOperation extends SerializeOperation {
		        
		protected void doExecute(Connection conn) throws Exception {
		    OutputConnection oc = (OutputConnection)conn;
			System.out.println("writing basic_pref to scratchpad");
			DataOutputStream dos = null;
			try {
				dos = oc.openDataOutputStream();
				dos.writeInt(_defaultFormLocation);
				dos.writeUTF(_defaultFormUrl);
			} finally {
				if (dos != null) dos.close();
			}
        }

		public String getConnectionString() {
			return BASIC_PREF_URI;
		}

		public int getMode() {
			return Connector.WRITE;
		}

        protected void doCompletion() throws Exception {
            // nothing to do.
        }

        protected void doException(Exception e) {
            if (e instanceof IOException) {
                _context.showErrorDialog("{ݒ̕ۑɎs܂B", e);               
            }
        }

    }
	
	class BasicPrefLoadOperation extends SerializeOperation {
        
		protected void doExecute(Connection conn) throws Exception {
			InputConnection oc = (InputConnection)conn;
			System.out.println("reading basic_pref from scratchpad");
			DataInputStream dis = null;
			try {
				dis = oc.openDataInputStream();
				_defaultFormLocation = dis.readInt();
				System.out.println("default form loc : " + _defaultFormLocation);
				_defaultFormUrl = dis.readUTF();
				System.out.println("default form url : " + _defaultFormUrl);
			} finally {
				if (dis != null) dis.close();
			}
		}
		
		public String getConnectionString() {
			return BASIC_PREF_URI;
		}

		public int getMode() {
			return Connector.READ;
		}

        public void setListener(OperetionListener observer) {
            // Nothing to do.
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doCompletion()
         */
        protected void doCompletion() throws Exception {
            // Nothing to do.
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
         */
        protected void doException(Exception e) {
            if (e instanceof IOException) {
                _defaultFormLocation = DEFAULT_FORM_LOC_HTTP;
                _defaultFormUrl = null;
            }
        }
	}

    
//	/* (non-Javadoc)
//	 * @see jp.haw.grain.sprout.SproutApp#createSubmissionOperation(jp.haw.grain.xforms.SubmissionElement)
//	 */
//	public FormSerializeOperation createSubmissionOperation(SubmissionElement element, boolean replace) {
//	    if (element == null) {
//            return new FormSubmissionOperation(_defaultFormUrl, _defaultContentType, replace);
//        } else {
//            String uri = element.getCanonicalActionUri();
//    		String contentType = "application/xml";
//            
//// TODO            
//    		Node node = null;
////    		Node node = element.getBindingNode();
////            if (node == null) node = element.getContextModel().getInitialContextNode();
//////    		if (node == null) node = element.getContextModel().getInstanceNode("/");
////    		System.out.println("createSubmissionOperation: bindingNode = " + node);
//    		return new FormSubmissionOperation(uri, contentType, node, replace);
//        }
//	}
//
//	/* (non-Javadoc)
//	 * @see jp.haw.grain.sprout.SproutApp#createSubmissionOperation(jp.haw.grain.xforms.SubmissionElement)
//	 */
//	public DocumentSerializeOperation createExternalInstanceLoadOperation(Instance instance) {
//		String uri = instance.getCanonicalSrcUri();
//		String contentType = "application/xml";
//		return new DocumentLoadOperation(uri, contentType);
//	}

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.SproutApp#showMessage(java.lang.String)
     */
    public void showMessage(String eventType) {
        _context.showErrorDialog(eventType, new Throwable("processing error"));
    }
    
    /* (non-Javadoc)
     * @see jp.grain.sprout.CommandExecuter#getFormContext()
     */
    public FormContext getFormContext() {
        return _context;
    }
    
		
}
