/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/19 13:11:28
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Element;
import jp.grain.spike.Node;


/**
 * CCvf킷ۃNXB
 * 
 * @version $Id: Inline.java 162 2006-02-11 05:57:55Z go $
 * @author Go Takahashi
 */
abstract public class Inline extends Box {
    
    protected Font _font;

    /**
     * @param name
     */
    public Inline(String name) {
        super(name);
    }

    public boolean fitWithIn(Row row) {
        return row.addChildInline(this);
    }
        
    public int getLeading(int height) {
        return height - getBoxHeight();
    }

    public boolean isLineBreak() {
        return "true".equals(getAttribute("break"));
    }

    /**
     * @return
     */
    public boolean isContinue() {
        return false;
    }
    
    public void init(Form form) {
        _font = Font.getFontOf(this);
        super.init(form);
    }
    
    public void initChildren(Form form) {
        // noting to do
    }
    
    protected void applyChildren(Form form) {
        // nothing to do
    }
   
//    /**
//     * 
//     * @param selector
//     * @param action
//     * @return returns true when this element need to repaint, otherwise false 
//     */
//    public boolean handleAction(FormContext ctx, int action, int selector) {
//        if (action == FormContext.ACT_FOCUS_IN) {
//// TODO dispatch event
////            if (this.element instanceof FormControlElement) {
////                ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusIn", true, false));
////            }
//        } else if (action == FormContext.ACT_FOCUS_OUT) {
//// TODO dispatch event
////            if (this.element instanceof FormControlElement) {
////                ((FormControlElement)this.element).dispatchEvent(new Event("DOMFocusOut", true, false));
////            }
//        }
//        return false;
//    }
//    
//    public boolean isCaptureEnable() {
//        return false;
//    }
    
    public String getBindingSimpleContent() {
        Node bindingNode = getBindingNode();
        if (bindingNode == null) return EMPTY_STRING;
        return bindingNode.getSimpleContent();
    }

    public void setBindingSimpleContent(String content) {
        Node bindingNode = getBindingNode();
        if (bindingNode == null) return;
        bindingNode.setSimpleContent(content);
    }
    
    public void preProcess(Node parent) {
        if (parent instanceof InlineBlock) {
            ((InlineBlock)parent).addChildInline(this);
        } else if (parent instanceof Box) {
            ((Box)parent).setLabel(this);
        }
    }
    
    public void postProcess(Node parent) {
        // Default action is do nothing.
    }
    
}
