/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/23 10:22:55
 * 
 */
package jp.grain.sprout.ui;

import jp.grain.spike.Element;
import jp.grain.spike.Node;

/**
 * TODO Item
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Item extends Element {

    public static final String NAME = "item";
    private String label;
    private String value;
    
    /**
     * @param name
     */
    public Item() {
        super(NAME);
    }

    public String getLabel() {
        return label;
    }
    
    public void setLabel(String label) {
        this.label = label;
    }
    
    public String getValue() {
        return value;
    }
    
    public void setValue(String value) {
        this.value = value;
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Node#preProcess(jp.grain.spike.Node)
     */
    public void preProcess(Node parent) {
        if (parent instanceof SelectComponent) {
            ((InlineComponent)parent).addChild(this);
        } else if (parent instanceof Element) {
            Element e = (Element)parent;
            if ("choices".equals(e.getName())) {
                e.addChild(this);
            }
        }
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Node#postProcess(jp.grain.spike.Node)
     */
    public void postProcess(Node parent) {
        // notihng to do
    }

}
