/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/24 16:50:00 
 */
package jp.grain.sprout.ui;



/**
 * TextBox
 * 
 * @version $Id: TextBox.java 171 2006-03-24 05:03:11Z eddie $
 * @author Go Takahashi
 */
public class TextBox extends InlineComponent {

    public static final String NAME = "textbox";
    
    public static final int INPUT_DEVICE_IME = 0;
    public static final int INPUT_DEVICE_QR = 1;
        
    private static final int COLOR_BLACK = 0x000000; // 
    private static final int COLOR_FIELD = 0xFFFFFF; // wi
    private static final int COLOR_EDGE_DARK = 0x333333; // GbW(Áj
    private static final int COLOR_EDGE_LIGHT = 0xCCCCCC; // GbW()
    private static final int COLOR_FOCUS = 0xFF6666; // IIF
    private static final int SIZE_BORDER = 1;
    private static final int SIZE_MARGIN = 1;
    private static final int SIZE_MINIMUM = SIZE_MARGIN + 3;
    private static final int SIZE_PADDING = 2;
    private static final int SIZE_DEFAULT = 50;
        
    private String inputMode;
    private int inputDevice;
    private boolean isSecret;
    private boolean isMultiLine;
    /**
     * 
     */
    public TextBox() {
        super(NAME);
        _margin = SIZE_MARGIN;
        _border = SIZE_BORDER;
        _padding = SIZE_PADDING;        
    }
    
    public void apply(Form form) {
        super.apply(form);
        if (_width < 0) _width = SIZE_DEFAULT;
        if (_width < SIZE_MINIMUM) _width = SIZE_MINIMUM;
        if (_height < _font.getHeight()) _height = _font.getHeight();        
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
     */
    public void draw(DrawContext dc) {
        dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
        dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2, _height + (_padding + _border) * 2);
        if (getOwnerForm().isFocusingOn(this)) {
            dc.setColor(COLOR_FOCUS);
            dc.drawRect(0, 0, getBoxWidth() - 1, getBoxHeight() - 1);
        }
        dc.setColor(COLOR_BLACK);
        String text = getBindingSimpleContent();
        text = (text != null) ? text : "";
        dc.clipRect(getContentX(), getContentY(), getWidth(), getHeight());
        dc.setFont(_font);
        
        if(!isMultiLine) { // g
            int ndx = text.indexOf("\\n");
            if(ndx != -1) text = text.substring(0, ndx);
        }
        if(isSecret) {
            int secret = text.length();
            text = "";
            for(int i=0; i<secret; i++) text = text + "*";
        }
        
        dc.drawString((text != null) ? text : "", getContentX(), getContentY());
        dc.clearClip();
    }

    /* (non-Javadoc)
     * @see jp.haw.grain.sprout.InlineElement#action(int, int)
     */
    public boolean handleAction(FormContext view, int action, int selector) {
        super.handleAction(view, action, selector);
        if (action == FormContext.ACT_RELEASED) {
            if (selector == FormContext.SEL_SELECT) {
                if (this.inputDevice == INPUT_DEVICE_QR) {
                    view.launchCodeReader();                    
                } else {
                    view.launchIME(getBindingSimpleContent(), this.inputMode, isSecret);
                }
            }
        } else if (action == FormContext.ACT_IME_RESULT) {
            if (selector == FormContext.SEL_IME_COMMIT) {
                setBindingSimpleContent(view.getIMEText());
                view.requestRender();
                //TODO dispatch event
                //fce.dispatchEvent(new Event("xforms-value-changed", true, false));
                return true;
            }
        }
        return false;
    }

    public void setSecret(boolean secret) {
        isSecret = secret;
    }
    
    public boolean getSecret() {
        return isSecret;
    }
    
    public void setMultiline(boolean multiline) {
        isMultiLine = multiline;
    }
    
    public boolean getMultiline() {
        return isMultiLine;
    }
    
    public void setInputDevice(int mode) {
        inputDevice = mode;
    }
    
    public int getInputDevice() {
        return inputDevice;
    }
}
