/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.mortbay.http.BufferedOutputStream;
import org.mortbay.http.ChunkingOutputStream;
import org.mortbay.http.HttpFields;
import org.mortbay.http.HttpMessage;
import org.mortbay.http.NullableOutputStream;
import org.mortbay.util.ByteArrayPool;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpOutputStream
extends FilterOutputStream
implements OutputObserver,
HttpMessage.HeaderWriter {
    static final String __CRLF = "\r\n";
    static final byte[] __CRLF_B = IO.CRLF_BYTES;
    static final byte[] __CHUNK_EOF_B = new byte[]{48, 13, 10};
    static final int __BUFFER_SIZE = 4096;
    static final int __FIRST_RESERVE = 512;
    public static final Class[] __filterArg = new Class[]{class$java$io$OutputStream == null ? (class$java$io$OutputStream = HttpOutputStream.class$("java.io.OutputStream")) : class$java$io$OutputStream};
    private OutputStream _realOut;
    private NullableOutputStream _nullableOut;
    private HttpMessage.HeaderWriter _headerOut;
    private BufferedOutputStream _bufferedOut;
    private ChunkingOutputStream _chunkingOut;
    private boolean _written = false;
    private ArrayList _observers;
    private int _bytes;
    private int _bufferSize;
    private int _headerReserve;
    private boolean _bufferHeaders;
    private HttpWriter _iso8859writer;
    private HttpWriter _utf8writer;
    boolean _closing = false;
    static /* synthetic */ Class class$java$io$OutputStream;

    public HttpOutputStream(OutputStream outputStream) {
        this(outputStream, 4096, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int bufferSize) {
        this(outputStream, bufferSize, 512);
    }

    public HttpOutputStream(OutputStream outputStream, int bufferSize, int headerReserve) {
        super(outputStream);
        this._bufferSize = bufferSize;
        this._headerReserve = headerReserve;
        this._realOut = outputStream;
        this._nullableOut = new NullableOutputStream(this._realOut, headerReserve);
        this._headerOut = this._nullableOut;
        this.out = this._nullableOut;
    }

    public void setBufferedOutputStream(BufferedOutputStream bos, boolean bufferHeaders) {
        this._bufferedOut = bos;
        this._bufferedOut.setCommitObserver(this);
        this._bufferHeaders = bufferHeaders;
    }

    public OutputStream getOutputStream() {
        return this._realOut;
    }

    public OutputStream getFilterStream() {
        return this.out;
    }

    public void setFilterStream(OutputStream filter) {
        this.out = filter;
    }

    public boolean isWritten() {
        return this._written;
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) throws IllegalStateException {
        if (size <= this._bufferSize) {
            return;
        }
        if (this._bufferedOut != null && this._bufferedOut.size() > 0) {
            throw new IllegalStateException("Not Reset");
        }
        try {
            boolean fixed;
            this._bufferSize = size;
            if (this._bufferedOut != null) {
                fixed = this._bufferedOut.isFixed();
                this._bufferedOut.setFixed(false);
                this._bufferedOut.ensureSize(size);
                this._bufferedOut.setFixed(fixed);
            }
            if (this._chunkingOut != null) {
                fixed = this._chunkingOut.isFixed();
                this._chunkingOut.setFixed(false);
                this._chunkingOut.ensureSize(size);
                this._chunkingOut.setFixed(fixed);
            }
        }
        catch (IOException e) {
            Code.warning(e);
        }
    }

    public int getBytesWritten() {
        return this._bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBuffer() throws IllegalStateException {
        if (this.out != null && this.out != this._headerOut) {
            ArrayList save_observers = this._observers;
            this._observers = null;
            try {
                try {
                    this._nullableOut.nullOutput();
                    this.out.close();
                }
                catch (Exception e) {
                    Code.ignore(e);
                    Object var4_4 = null;
                    this._observers = save_observers;
                    this._nullableOut.resetStream();
                }
                Object var4_3 = null;
                this._observers = save_observers;
                this._nullableOut.resetStream();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this._observers = save_observers;
                this._nullableOut.resetStream();
                throw throwable;
            }
        }
        if (this._bufferedOut != null) {
            this._bufferedOut.resetStream();
        }
        if (this._chunkingOut != null) {
            this._chunkingOut.resetStream();
        }
        this._headerOut = this._nullableOut;
        this.out = (OutputStream)((Object)this._headerOut);
        this._bytes = 0;
        this._written = false;
        try {
            this.notify(1);
        }
        catch (IOException e) {
            Code.ignore(e);
        }
    }

    public void addObserver(OutputObserver observer) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(observer);
        this._observers.add(null);
    }

    public void addObserver(OutputObserver observer, Object data) {
        if (this._observers == null) {
            this._observers = new ArrayList(4);
        }
        this._observers.add(observer);
        this._observers.add(data);
    }

    public void resetObservers() {
        this._observers = null;
    }

    public void nullOutput() throws IOException {
        this._nullableOut.nullOutput();
    }

    public boolean isNullOutput() throws IOException {
        return this._nullableOut.isNullOutput();
    }

    public void setChunking() {
        if (this._chunkingOut == null) {
            this._chunkingOut = new ChunkingOutputStream(this._nullableOut, this._bufferSize, this._headerReserve);
            this._chunkingOut.setCommitObserver(this);
        }
        this._headerOut = this._chunkingOut;
        this.out = this._chunkingOut;
    }

    public boolean isChunking() {
        return this._chunkingOut != null && this._headerOut == this._chunkingOut;
    }

    public void resetStream() throws IOException, IllegalStateException {
        this._closing = false;
        if (this.isChunking()) {
            this.close();
        }
        this._written = false;
        if (this._bufferedOut != null) {
            this._bufferedOut.resetStream();
        }
        if (this._chunkingOut != null) {
            this._chunkingOut.resetStream();
        }
        this._nullableOut.resetStream();
        this._headerOut = this._nullableOut;
        this.out = this._nullableOut;
        this._bytes = 0;
        if (this._observers != null) {
            this._observers.clear();
        }
    }

    public void destroy() {
        if (this._bufferedOut != null) {
            this._bufferedOut.destroy();
        }
        this._bufferedOut = null;
        if (this._chunkingOut != null) {
            this._chunkingOut.destroy();
        }
        this._chunkingOut = null;
        if (this._nullableOut != null) {
            this._nullableOut.destroy();
        }
        this._nullableOut = null;
        if (this._iso8859writer != null) {
            this._iso8859writer.destroy();
        }
        this._iso8859writer = null;
        if (this._utf8writer != null) {
            this._utf8writer.destroy();
        }
        this._utf8writer = null;
    }

    public void setTrailer(HttpFields trailer) {
        if (!this.isChunking()) {
            throw new IllegalStateException("Not Chunking");
        }
        this._chunkingOut.setTrailer(trailer);
    }

    public void writeHeader(HttpMessage httpMessage) throws IOException {
        if (this.isNullOutput()) {
            this._nullableOut.writeHeader(httpMessage);
        } else if (this._bufferHeaders) {
            this._bufferedOut.writeHeader(httpMessage);
        } else {
            this._headerOut.writeHeader(httpMessage);
        }
    }

    public void write(int b) throws IOException {
        this.prepareOutput();
        this.out.write(b);
        ++this._bytes;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.prepareOutput();
        this.out.write(b, off, len);
        this._bytes += len;
    }

    protected void prepareOutput() throws IOException {
        if (this.out == null) {
            throw new IOException("closed");
        }
        if (!this._written) {
            this._written = true;
            if (this.out == this._nullableOut) {
                if (this._bufferedOut == null) {
                    this._bufferedOut = new BufferedOutputStream(this._nullableOut, this._bufferSize, this._headerReserve, 0, 0);
                    this._bufferedOut.setCommitObserver(this);
                    this._bufferedOut.setBypassBuffer(true);
                    this._bufferedOut.setFixed(true);
                }
                this.out = this._bufferedOut;
                this._headerOut = this._bufferedOut;
            }
            this.notify(0);
            if (this.out == this._nullableOut) {
                this.notify(2);
            }
        }
    }

    public void flush() throws IOException {
        if (this.out != null) {
            if (this.out == this._nullableOut) {
                this.notify(2);
            }
            this.out.flush();
        }
    }

    public boolean isClosed() throws IOException {
        return this.out == null;
    }

    public void close() throws IOException {
        if (this.out == null) {
            return;
        }
        try {
            this._closing = true;
            if (this.out == this._nullableOut) {
                this.notify(2);
            }
            this.notify(4);
            if (this._bufferHeaders) {
                this._bufferedOut.close();
            } else if (this.out != null) {
                this.out.close();
            }
            this.out = null;
            this._headerOut = this._nullableOut;
            this.notify(5);
        }
        catch (IOException e) {
            Code.ignore(e);
        }
    }

    public void outputNotify(OutputStream out, int action, Object ignoredData) throws IOException {
        this.notify(action);
    }

    private void notify(int action) throws IOException {
        if (this._observers != null) {
            int i = this._observers.size();
            while (i-- > 0) {
                Object data = this._observers.get(i--);
                ((OutputObserver)this._observers.get(i)).outputNotify(this, action, data);
            }
        }
    }

    public void write(InputStream in, int len) throws IOException {
        IO.copy(in, this, (long)len);
    }

    private Writer getISO8859Writer() throws IOException {
        if (this._iso8859writer == null) {
            this._iso8859writer = new HttpWriter(StringUtil.__ISO_8859_1);
        }
        return this._iso8859writer;
    }

    private Writer getUTF8Writer() throws IOException {
        if (this._utf8writer == null) {
            this._utf8writer = new HttpWriter("UTF-8");
        }
        return this._utf8writer;
    }

    public Writer getWriter(String encoding) throws IOException {
        if (encoding == null || StringUtil.__ISO_8859_1.equalsIgnoreCase(encoding) || "ISO8859_1".equalsIgnoreCase(encoding)) {
            return this.getISO8859Writer();
        }
        if ("UTF-8".equalsIgnoreCase(encoding) || "UTF8".equalsIgnoreCase(encoding)) {
            return this.getUTF8Writer();
        }
        return new OutputStreamWriter((OutputStream)this, encoding);
    }

    public String toString() {
        return super.toString() + "\nout=" + this.out + "\nrealOut=" + this._realOut + "\nnullableOut=" + this._nullableOut + "\nheaderOut=" + this._headerOut + "\nbufferedOut=" + this._bufferedOut + "\nchunkingOut=" + this._chunkingOut;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HttpWriter
    extends Writer {
        private OutputStreamWriter _writer = null;
        private boolean _writting = false;
        private byte[] _buf = ByteArrayPool.getByteArray(4096);
        private String _encoding;

        HttpWriter(String encoding) {
            this._encoding = encoding;
        }

        public Object getLock() {
            return this.lock;
        }

        public void write(char c) throws IOException {
            if (this._writting) {
                this._writer.write(c);
            } else if (c >= '\u0000' && c <= '\u007f') {
                HttpOutputStream.this.write(c);
            } else {
                char[] ca = new char[]{c};
                this.writeEncoded(ca, 0, 1);
            }
        }

        public void write(char[] ca) throws IOException {
            this.write(ca, 0, ca.length);
        }

        public void write(char[] ca, int offset, int length) throws IOException {
            if (this._writting) {
                this._writer.write(ca, offset, length);
            } else {
                HttpOutputStream.this.prepareOutput();
                int s = 0;
                int i = 0;
                while (i < length) {
                    char c = ca[offset + i];
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[s++] = (byte)c;
                        if (s == this._buf.length) {
                            HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                            HttpOutputStream.this._bytes += s;
                            s = 0;
                        }
                    } else {
                        if (s > 0) {
                            HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                            HttpOutputStream.this._bytes += s;
                            s = 0;
                        }
                        this.writeEncoded(ca, offset + i, length - i);
                        break;
                    }
                    ++i;
                }
                if (s > 0) {
                    HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                    HttpOutputStream.this._bytes += s;
                    s = 0;
                }
            }
        }

        public void write(String s) throws IOException {
            this.write(s, 0, s.length());
        }

        public void write(String str, int offset, int length) throws IOException {
            if (this._writting) {
                this._writer.write(str, offset, length);
            } else {
                int s = 0;
                HttpOutputStream.this.prepareOutput();
                int i = 0;
                while (i < length) {
                    char c = str.charAt(offset + i);
                    if (c >= '\u0000' && c <= '\u007f') {
                        this._buf[s++] = (byte)c;
                        if (s == this._buf.length) {
                            HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                            HttpOutputStream.this._bytes += s;
                            s = 0;
                        }
                    } else {
                        if (s > 0) {
                            HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                            HttpOutputStream.this._bytes += s;
                            s = 0;
                        }
                        char[] chars = str.toCharArray();
                        this.writeEncoded(chars, offset + i, chars.length - (offset + i));
                        break;
                    }
                    ++i;
                }
                if (s > 0) {
                    HttpOutputStream.this.getFilterStream().write(this._buf, 0, s);
                    HttpOutputStream.this._bytes += s;
                    s = 0;
                }
            }
        }

        private void writeEncoded(char[] ca, int offset, int length) throws IOException {
            if (this._writer == null) {
                this._writer = new OutputStreamWriter((OutputStream)HttpOutputStream.this, this._encoding);
            }
            this._writting = true;
            this._writer.write(ca, offset, length);
        }

        public void flush() throws IOException {
            if (this._writting) {
                this._writer.flush();
            } else {
                HttpOutputStream.this.flush();
            }
            this._writting = false;
        }

        public void close() throws IOException {
            if (this._writting) {
                this._writer.flush();
            }
            HttpOutputStream.this.close();
            this._writting = false;
        }

        public void destroy() {
            ByteArrayPool.returnByteArray(this._buf);
            this._buf = null;
            this._writer = null;
            this._encoding = null;
        }
    }
}

