/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/03/30 11:53:16
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

import org.xmlpull.v1.XmlPullParserException;

import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ui.FormContext;

import com.nttdocomo.io.HttpConnection;

/**
 * TODO HttpPostOperation
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public abstract class HttpPostOperation extends SerializeOperation {

    protected String _uri;
    protected String _contentType;
    protected OperetionListener _listener;
    
    /**
     * 
     */
    public HttpPostOperation(String uri, String contentType) {
        _uri = uri;
        _contentType = contentType;
    }

    public String getConnectionString() {
    	return _uri;
    }

    public int getMode() {
    	return Connector.READ_WRITE;
    }

    public void setListener(OperetionListener listener) {
        _listener = listener;
    }
    
    protected void doExecute(Connection conn) throws Exception{
        System.out.println("submit uri : " + _uri);
        System.out.println("opening connection");
        HttpConnection httpConn = (HttpConnection)conn;
        sendRequest(httpConn);
        receiveResponse(httpConn);
    }

    private void sendRequest(HttpConnection hc) throws IOException {
//      hc.setRequestMethod(_node == null ? HttpConnection.GET : HttpConnection.POST);
      System.out.println("writing to stream");
      OutputStream os = null;
      try {
          hc.setRequestProperty("Content-Type", _contentType);
          os = hc.openOutputStream();
          writeRequest(os);
      } finally {
          if (os != null) os.close();
      }
      System.out.println("reading from stream");
    }

    private void receiveResponse(HttpConnection hc) throws IOException, XmlPullParserException {
        InputStream is = null;
        try {
            hc.connect();
            System.out.println("connected : " + hc.getResponseCode());
            if (hc.getResponseCode() != HttpConnection.HTTP_OK) {
                 throw new RuntimeException("HTTP ERROR [" + hc.getResponseCode() + "] : " + hc.getResponseMessage());
            }
            is = hc.openInputStream();
            readResponse(is);
        } finally {
            if (is != null) is.close();
        }
    }
    
    protected abstract void writeRequest(OutputStream os) throws IOException;
    protected abstract void readResponse(InputStream is) throws IOException, XmlPullParserException;
}
