package jp.grain.sprout.ui;


/**
 * @author nakajo
 */
public class Select extends SelectComponent {

	public static final String NAME = "select";
	public Select() {
		super(NAME);
		this._isMultiple = true;
	}

	/* (non-Javadoc)
	 * @see jp.haw.grain.sprout.Renderer#draw(jp.haw.grain.sprout.DrawContext)
	 */
	public void draw(DrawContext dc) {
		int sx, sy, sw, sh;
		dc.clearClip();
		sw = _width + (_padding + _border) * 2;
		sh = (_font.getHeight() + _padding * 2) * getChildCount() + _border * 2;
		int spaceConstant = 8 + _font.getHeight();
		// FOCUS
		if (getOwnerForm().isFocusingOn(this) && !_activate) {
			dc.setColor(COLOR_FOCUS);
			dc.drawRect(0, 0, getBoxWidth() + spaceConstant - 1, sh);
		}
		dc.setColor(COLOR_BLACK);
		if (getChildCount() == 0)
			return;
		// BOX
		dc.setEmbossParam(_border, COLOR_FIELD, COLOR_EDGE_DARK, COLOR_EDGE_LIGHT, false);
		dc.drawEmbossedRect(_margin, _margin, _width + (_padding + _border) * 2 + spaceConstant, sh - 1);
		// ITEMS & SHADE
		sx = _border + spaceConstant;
		sy = _border;
		sw = _padding * 2 + _width;
		sh = _padding * 2 + _font.getHeight();
		for (int i = 0; i < getChildCount(); ++i) {
			Item item = (Item)getChildElement(i);
			if (i == _currentIndex && _activate) {
				dc.setColor(COLOR_FOCUS);
				dc.fillRect(sx - spaceConstant + 1, sy + 1, sw + spaceConstant, sh);
				dc.setColor(COLOR_FIELD);
			} else {
				dc.setColor(COLOR_BLACK);
			}
			// CHECK
			if (_selections.contains(new Integer(i))) {
				dc.drawLine(_padding + 5, _padding + _font.getHeight() + sy - 5, _padding + 7, _padding + _font.getHeight() + sy - 3); // \
				dc.drawLine(_padding + 7, _padding + _font.getHeight() + sy - 3, _padding + _font.getHeight() - 3, _padding + sy + 3); // /
			}
			// CHECKBOX
			dc.drawRect(_padding * 2, (sy + _padding), _font.getHeight(), _font.getHeight());
			dc.drawString(item.getLabel(), sx + _padding, sy + _padding);
			sy += sh;
		}
	}

}
