/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/09 15:30:31
 * 
 */
package jp.grain.sprout.platform.doja;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

import com.nttdocomo.io.HttpConnection;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;
import jp.grain.sprout.ui.Button;
import jp.grain.sprout.ui.CharactorSequence;
import jp.grain.sprout.ui.Font;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.Inline;

/**
 * A test of Button
 * @version  $Id: ButtonTest.java 183 2006-04-03 12:29:35Z go $
 * @author Go Takahashi
 */
public class DividedConnectionTest extends TestCase {

    public DividedConnectionTest() {
    }

    public DividedConnectionTest(String name, TestMethod method) {
        super(name, method);
    }

    public void testConnection() {
        HttpConnection conn = null;
        try {
            conn = new DividedHttpConnection("http://localhost:8080/grain-server-test/test/j1-tokyo.jpg");
            conn.setRequestProperty("Content-Type", "image/jpeg");
            OutputStream os = null;
            try {
                os = conn.openOutputStream();
                writeTo(os, "resource:///j1-tokyo.jpg");
            } finally {
                if (os != null) os.close();
            }
            conn.connect();
            InputStream is = null;
            try {
                is = conn.openInputStream();
                assertTrue(readAndCompareFrom(is, "resource:///j1-tokyo.jpg"));
            } finally {
                if (is != null) is.close();
            }
        } catch (IOException e) {
            e.printStackTrace();
            fail();
        } finally {
            if (conn != null) {
                try {
                    conn.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
    
    public Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new DividedConnectionTest("testConnection", new TestMethod() {
            public void run(TestCase tc) {
                try {
                    ((DividedConnectionTest)tc).testConnection();             
                } catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }));
        return suite;
    }
    
    void writeTo(OutputStream os, String from) throws IOException {
        InputStream is = null;
        byte[] buf = new byte[256];
        try {
            is = Connector.openInputStream(from);
            for (;;) {
                int len = is.read(buf);
                if (len == -1)  return;
                os.write(buf, 0, len);
            }
        } finally {
            if (is != null) is.close();
        }
    }
    
    boolean readAndCompareFrom(InputStream is, String with) throws IOException {
        InputStream ris = null;
        try {
            ris = Connector.openInputStream(with);
            int nth = 0;
            for (;;) {
                int rb = ris.read();
                int ib = is.read();
//                System.out.println("nth=" + nth + ", resorce=" + Integer.toHexString(rb) + ", input=" + Integer.toHexString(ib));
                if (rb != ib) return false;
                if (rb == -1 || ib == -1) break;
                nth++;
            }
            return true;
        } finally {
            if (is != null) is.close();
        }        
    }
}
