package jp.grain.sprout.platform.doja;

import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestMethod;
import j2meunit.framework.TestSuite;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;

import jp.grain.spike.BinaryXMLParser;
import jp.grain.spike.Document;
import jp.grain.sprout.Initializer;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.model.Instance;
import jp.grain.sprout.model.Submission;
import jp.grain.sprout.ui.Block;
import jp.grain.sprout.ui.Box;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;
import jp.grain.sprout.ui.Label;
import jp.grain.sprout.ui.TabBlock;

import org.xmlpull.v1.XmlPullParserException;

public class TabBlockTest extends TestCase {

    private Form form;
    
    public TabBlockTest() {
    }

    public TabBlockTest(String name, TestMethod method) {
        super(name, method);
    }
    
    protected void setUp() throws Exception {
        // gbxml rev 154 06/02/02
        MockSproutApp app = new MockSproutApp("resource:///new_company.gbxml");
        app.start();
        
        FormContextImpl ctx = (FormContextImpl) app.getFormContext();
        ctx.getInitializer().join();
        form = ctx.getForm();
    }
    
    public void test1() {
        
        Box tabBlockBox = form.getRootBlock().getChildBox(1);
        Box blockBox = ((TabBlock)tabBlockBox).getChildBox(0);
        Box inlineBlockBox = ((Block)blockBox).getChildBox(0);
        
        assertSame("focus element test 1: " + form.getFocusedComponent().getClass().getName(), form.getFocusedComponent(), tabBlockBox);
        assertEquals("class name test 2: " + tabBlockBox.getClass().getName(), "jp.grain.sprout.ui.TabBlock", tabBlockBox.getClass().getName());
        assertEquals("attribute test 3: " + tabBlockBox.getAttribute("tab"), "upper", tabBlockBox.getAttribute("tab"));
        assertEquals("class name test 4: " + blockBox.getClass().getName(), "jp.grain.sprout.ui.Block", blockBox.getClass().getName());
        assertEquals("label test 5: " + blockBox.getLabel().getText(), "1:{", blockBox.getLabel().getText());
        assertEquals("attribute test 6: " + blockBox.getAttribute("selected"), "true", blockBox.getAttribute("selected"));
        assertEquals("class name test 7: " + inlineBlockBox.getClass().getName(), "jp.grain.sprout.ui.InlineBlock", inlineBlockBox.getClass().getName());
    }
    
    public void test2() {
        
        form = new Form();
        TabBlock tabBlock = new TabBlock();
        Block block = new Block();

        //Note: Need to setChildren with "new Vector()", otherwise a Null PE is thrown.
        block.setChildren(new Vector());
        
        tabBlock.addAttribute("tab", "upper");
        tabBlock.addChildBlock(block);
        
        Label label = new Label();
        label.setText("label");
        block.setLabel(label);
        
        tabBlock.apply(form);
        
        assertEquals("label test 8: " + tabBlock.getChildBox(0).getLabel().getText(), "label", tabBlock.getChildBox(0).getLabel().getText());
        assertEquals("attribute test 9: " + tabBlock.getAttribute("tab"), "upper", tabBlock.getAttribute("tab"));
        assertEquals("class name test 10: " + "jp.grain.sprout.ui.Block", "jp.grain.sprout.ui.Block", tabBlock.getChildBox(0).getClass().getName());
    }
    
    public Test suite() {
        TestSuite suite = new TestSuite();
        
        suite.addTest(new TabBlockTest("test1", new TestMethod() {
            public void run(TestCase tc) { ((TabBlockTest)tc).test1(); }
        }));
        
        suite.addTest(new TabBlockTest("test2", new TestMethod() {
            public void run(TestCase tc) { ((TabBlockTest)tc).test2(); }
        }));
        
        return suite;
    }

    /**
     * Mock Classes 
     */
    class MockSproutApp extends GrainApp {

        Throwable error;
        String defaultUri;
        
        MockSproutApp(String defaultUri) {
            setDefaultFormUrl(defaultUri);
            setDefaultFormLocation(DEFAULT_FORM_LOC_HTTP);
            _context = new MockFormContextImpl(this);
        }
        
        public void loadBasicPref() {
        }
        
        public FormContext getFormContext() {
            return _context;
        }
    }
    
    class MockFormContextImpl extends FormContextImpl {

        MockFormContextImpl(GrainApp app) {
            super(app);
        }
                
        public SerializeOperation createSubmissionOperation(String url) {
            return new MockSubmissionOperation(url, this);
        }

        public SerializeOperation createSubmissionOperation(Submission element) {
            if (element == null) {
                return new MockSubmissionOperation(_app.getDefaultFormUrl(), this);
            } else {
                Form f = (Form)element.getDocument();
                return new MockSubmissionOperation(f.createCanonicalUrl(element.getActionUrl()), this);
            }
        }
        
        public SerializeOperation createExternalInstanceLoadOperation(Instance element) {
            return super.createExternalInstanceLoadOperation(element);
        }
    }
    
    class MockSubmissionOperation extends SerializeOperation {

        private String url;
        private Form form;
        private Initializer initializer;
        
        MockSubmissionOperation(String url, FormContext context) {
            this.url = url;
            this.initializer = new Initializer(context);
        }

        public String getConnectionString() {
            return this.url;
        }

        public int getMode() {
            return Connector.READ;
        }

        public Document getInstanceDocument() {
            return null;
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.FormSerializeOperation#setListener(jp.grain.sprout.OperetionListener)
         */
        public void setListener(OperetionListener observer) {
            // TODO Auto-generated method stub
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doExecute(javax.microedition.io.Connection)
         */
        protected void doExecute(Connection conn) throws Exception {
            InputStream is = null;
            try {
                is = ((InputConnection)conn).openInputStream();
                BinaryXMLParser parser = BinaryXMLParser.newInstance(is, "SJIS");
                FormBuilder builder = new FormBuilder(parser, getConnectionString(), true);
                builder.build();
                this.form = (Form)builder.getDocument();
            } catch (IOException e) {
                e.printStackTrace();
                throw e;
            } catch (XmlPullParserException e) {
                e.printStackTrace();
            } finally {
                if (is != null) is.close();
            }
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doCompletion()
         */
        protected void doCompletion() throws Exception {
            this.initializer.init(this.form);
            this.initializer.start();
        }

        /* (non-Javadoc)
         * @see jp.grain.sprout.SerializeOperation#doException(java.lang.Exception)
         */
        protected void doException(Exception e) {
            // TODO Auto-generated method stub
            
        }
    }
}
