/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2005/07/26 15:07:37
 * 
 */
package jp.grain.spike;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

//import jp.grain.spike.Text;
import jp.grain.sprout.ui.CharactorSequence;

/**
 * BinaryXMLSerializer
 * @version $Id: BinaryXMLSerializer.java 248 2006-04-09 16:14:47Z go $
 * @author Le Phuong Thuy
 */

public class BinaryXMLSerializer {

    private Node node;

    // private OutputStream os;
    // private ByteArrayOutputStream os;
    public static final int ELEMENT_START_TAG = 0x01;

    public static final int EMPTY_ELEMENT_TAG = 0x02;

    public static final int ATTRIBUTE_TAG = 0x03;

    public static final int TEXT_TAG = 0x04;

    public static final int PREFIXMAPPING_TAG = 0x05;
    
    public static final int CDATA_TAG = 0x06;

    public static final int ELEMENT_END_TAG = 0x09;

    public static final int NONE_MASK = 0x00;

    public static final int INDEXED_MASK = 0x10;

    public static final int NS_MASK = 0x20;

    public static final int TEXT_TERMINATOR = 0x00;

    private String textEncoding = "SJIS";

    private ByteArrayOutputStream out = new ByteArrayOutputStream();


    private Hashtable nameMap = new Hashtable();
    private Vector nameList = new Vector();
    private Stack prefixStack = new Stack();
    private Vector prefixList = new Vector();
    private Vector rootPrefixList = new Vector();
        
    /**
     * @param node
     *            VACYΏۂXMLm[h
     */
    public BinaryXMLSerializer(Node node) {
        this.node = node;
    }

    /**
     * XMLhLgc[w肵o̓Xg[ɃVACYB
     */

    public void serializeTo(OutputStream os) throws IOException {
    	System.out.println("call serializeNode.");
        serializeNode(this.node);
        System.out.println("size: " + this.out.size());
        os.write(toVariableLengthNumber(this.out.size()));
        System.out.println("dic-size: " + this.nameMap.size());
        os.write(toVariableLengthNumber(this.nameMap.size()));
        os.write(toVariableLengthText("1.0"));
        os.write(TEXT_TERMINATOR);
        os.write(toVariableLengthText(this.textEncoding));
        os.write(TEXT_TERMINATOR);
        for (int i = 0; i < this.nameList.size(); ++i) {
            String name = (String) this.nameList.elementAt(i);
            os.write(toVariableLengthNumber(i + 1));
            os.write(toVariableLengthText(name));
            os.write(TEXT_TERMINATOR);
            System.out.println("dic entry: " + (i + 1) + " = " + name);
        }
        for (int i = 0; i < this.rootPrefixList.size(); i++) {
            Element.Namespace ns = (Element.Namespace)this.prefixList.elementAt(i);
            writePrefixMapping(os, this.prefixList.indexOf(ns) + 1, ns);
        }
        os.write(this.out.toByteArray());
    }

    // DOMc[ׂ̂Ẵm[hoCiϊ
    private void serializeNode(Node node) throws UnsupportedEncodingException, IOException {
    	System.out.println(".serializeNode: node="+node);
        if (node instanceof Element) {
            Element ne = (Element) node;
            System.out.println("node is ELEMENT!: elem="+ne.getName());
            // vfׂ̂Ănamespace̎擾
            System.out.println("start regist NamespaceMapping!");
            Element.Namespace[] ns = ne.getNamespaces();
            if (ns.length > 0) {
                writePrefixMappings(ns);
                this.prefixStack.push(ns);
            }
            System.out.println("writeStartOrEmptyTag");
            boolean empty = (ne.getText() == null || ne.getText().length() == 0 ) && ne.getChildCount() == 0;
            writeStartOrEmptyTag(empty, ne);
            System.out.println("End writeStartOrEmptyTag");
            System.out.println(".serializeNode: start serialize children: count="+ne.getChildCount());
            if (ne.getText() != null && ne.getText().length() > 0) {
                this.out.write(this.toVariableLengthNumber(TEXT_TAG));
                System.out.println("Text:" + node);
                this.out.write(this.toVariableLengthText(ne.getText()));
                this.out.write(this.toVariableLengthNumber(TEXT_TERMINATOR));
            }
            for (int i = 0; i < ne.getChildCount(); ++i) {
            	System.out.println("serialized Child["+i+"]");
                Node child = ne.getChildElement(i);
                if (child == null) continue;
                serializeNode(child);
            }
            if (!empty) this.out.write(this.toVariableLengthNumber(ELEMENT_END_TAG));
            if (ns.length > 0) this.prefixStack.pop();
        } else if (node instanceof CDataNode) {
            CDataNode cdatanode = (CDataNode)node;
            this.out.write(this.toVariableLengthNumber(CDATA_TAG));
            this.out.write(this.toVariableLengthNumber(cdatanode.getData().length));
            this.out.write(cdatanode.getData());
        } 
    }

    private byte[] toVariableLengthNumber(int i) {

        byte[] b = null;

        if (0x0 <= i && i <= 0x7F) {
            b = new byte[1];
            b[0] = (byte) (0x0 | i);
        } else if (0x80 <= i && i <= 0x7FF) {
            b = new byte[2];
            b[0] = (byte) (0xc0 | (byte) (i >> 6));
            b[1] = (byte) (0x80 | (0x3F & (byte) i));
        } else if (0x800 <= i && i <= 0xFFFF) {
            b = new byte[3];
            b[0] = (byte) (0xe0 | (byte) (i >> 12));
            b[1] = (byte) (0x80 | (0x3F & (byte) (i >> 6)));
            b[2] = (byte) (0x80 | (0x3F & (byte) i));
        } else if (0x10000 <= i && i <= 0x1FFFFF) {
            b = new byte[4];
            b[0] = (byte) (0xf0 | (byte) (i >> 18));
            b[1] = (byte) (0x80 | (0x3F & (byte) (i >> 12)));
            b[2] = (byte) (0x80 | (0x3F & (byte) (i >> 6)));
            b[3] = (byte) (0x80 | (0x3F & (byte) i));
        }
        return b;
    }

    private byte[] toVariableLengthText(String text) throws UnsupportedEncodingException {
        return text.getBytes(this.textEncoding);
    }


    private int getPrefixIndexOf(String prefix) {
    	System.out.println(".getPrefixIndexOf[prefix="+prefix+"]");
		System.out.println(".getPrefixIndexOf: prefixStack="+prefixStack);
        for (int i = this.prefixStack.size() - 1; i >= 0; i--) {
			Element.Namespace[] ns = (Element.Namespace[])this.prefixStack.elementAt(i);
            for (int n = 0; n < ns.length; ++n) {                
                System.out.println(".getPrefixIndexOf: ns="+ns[n]._prefix);
                if (ns[n]._prefix != null && ns[n]._prefix.equals(prefix)) {
                    return this.prefixList.indexOf(ns[n]) + 1;
                }
            }
        }
        return findParentPrefixMapping(prefix);
    }

    private int findParentPrefixMapping(String prefix) {
        System.out.println(".findParentPrefixMapping: prefix :" + prefix);
        System.out.println(".findParentPrefixMapping: perent :" + ((Element)this.node).getParentElement());
        for (int i = 0; i < this.rootPrefixList.size(); i++) {
            Element.Namespace[] ns = (Element.Namespace[])this.prefixList.elementAt(i);
            System.out.println(".findParentPrefixMapping: ns="+ns[i]._prefix);
            if (ns[i]._prefix != null && ns[i]._prefix.equals(prefix)) {
                return this.prefixList.indexOf(ns[i]) + 1;
            }
        }
        System.out.println(".findParentPrefixMapping: parse parents");
        Element root = (Element)this.node;
        for (Element elem = root.getParentElement(); elem != null; elem = elem.getParentElement()) {
            System.out.println(".findParentPrefixMapping: elem = " + elem.getName());
            Element.Namespace[] ns = elem.getNamespaces();
            for (int i = 0; i < ns.length; i++) {
                System.out.println(".findParentPrefixMapping: prefix=" + ns[i]._prefix);
                if (ns[i]._prefix != null && ns[i]._prefix.equals(prefix)) {
                    this.rootPrefixList.addElement(ns[i]);
                    this.prefixList.addElement(ns[i]);
                    return this.prefixList.size();
                }
            }
        }
        System.out.println(".findParentPrefixMapping: cant find");        
        return -1;
    }
    
    private void registName(String name) {
        if (name.length() < 3) return;
        if (this.nameMap.containsKey(name)) return;
        this.nameList.addElement(name);
        this.nameMap.put(name, new Integer(this.nameList.size()));
    }
    
    private int getNameIndexOf(String name) {
        Integer index = (Integer) this.nameMap.get(name);
        if (index == null) return -1;
        return index.intValue();
    }

    private void writePrefixMappings(Element.Namespace[] ns) throws IOException {
    	System.out.println(".registPrefixMapping: mapping length="+ns.length);
        for (int i = 0; i < ns.length; ++i) {
            this.prefixList.addElement(ns[i]);
            writePrefixMapping(this.out, this.prefixList.size(), ns[i]);
        }
    }
    
    private void writePrefixMapping(OutputStream os, int index, Element.Namespace n) throws IOException {
        int indexed = (n._prefix == null || n._prefix.length() == 0) ? NONE_MASK : INDEXED_MASK;
        os.write(indexed | PREFIXMAPPING_TAG);
        if (indexed == INDEXED_MASK) {
            os.write(toVariableLengthNumber(index));
            System.out.println("ns index : " + index);
            os.write(toVariableLengthText(n._prefix));
            System.out.print(n._prefix + ",");
            os.write(TEXT_TERMINATOR);
        }
        os.write(toVariableLengthText(n._uri));
        System.out.println(n._uri);
        os.write(TEXT_TERMINATOR);
        
    }
    
//    private boolean containnamespace(String[] ns) {
//        if (ns[0].equals(this.getPrefixbyUri(ns[1])))
//            return true;
//        return false;
//    }

//    private String getPrefixbyUri(String uri) {
//        if (uri == null)
//            return null; // uriprefixԂ
//        Enumeration e = this.prefixMap.elements();
//        while (e.hasMoreElements()) {
//            String[] str = (String[]) e.nextElement();
//            if (str[1].equals(uri)) {
//                return str[0];
//            }
//        }
//        return null;
//    }

    protected void writeName(String name) throws IOException {
        int index = getNameIndexOf(name);
        if (index > 0) {
            this.out.write(this.toVariableLengthNumber(index));
            System.out.println("write name: " + index + " as " + name);
        } else {
            this.out.write(this.toVariableLengthText(name));
            this.out.write(TEXT_TERMINATOR);
            System.out.println("write name: " + name);
        }
    }

    protected void writeValue(String value) throws IOException {
        this.out.write(this.toVariableLengthText(value));
        this.out.write(TEXT_TERMINATOR);
        System.out.println("write value: " + value);
    }

    void writeStartOrEmptyTag(boolean empty, Element e) throws IOException {
        System.out.println("write start tag...");
        System.out.println("registed NamespaceMapping");
        
        if (e.getName() != null) {
            registName(e.getName());
        }
        writeTagHeader(empty, e.getPrefix(), e.getName());
        writeName(e.getName());
        System.out.println(".writeStartOrEmptyTag: write attributes: count="+e.getAttributeCount());
        for (int i = 0; i < e.getAttributeCount(); ++i) {
        	System.out.println("write attribute["+i+"]");
            this.registName(e.getAttributeName(i));
            writeAttribute(e.getAttributeName(i), e.getAttributePrefix(i), e.getAttributeValue(i));
			System.out.println("write attribute["+i+"] END");
        }
    }

    /*
     * void writeStartTag(String Prefix,String Name,Enumeration attributes)
     * throws IOException { System.out.println("write start tag...");
     * writeTagHeader(false,Prefix,Name); writeName(Name); if(attributes!=null){
     * while(attributes.hasMoreElements()){ String[]
     * str=(String[])attributes.nextElement(); String
     * p=BinaryXMLSerializer.this.getPrefixbyUri(str[0]); str[0]=p;
     * writeAttribute(str); } } } void writeEmptyTag(String Prefix,String
     * Name,Enumeration attributes) throws IOException {
     * System.out.println("write start tag...");
     * writeTagHeader(true,Prefix,Name); writeName(Name); if(attributes!=null){
     * while(attributes.hasMoreElements()){ String[]
     * str=(String[])attributes.nextElement(); String
     * p=BinaryXMLSerializer.this.getPrefixbyUri(str[0]); str[0]=p;
     * writeAttribute(str); } } }
     */

    private void writeTagHeader(boolean empty, String prefix, String name) throws IOException {
        int n = (prefix == null || prefix.length() == 0) ? 0x00 : NS_MASK;
        int i = (this.nameMap.containsKey(name)) ? 0x00 : INDEXED_MASK;
        int e = (!empty) ? ELEMENT_START_TAG : EMPTY_ELEMENT_TAG;
        this.out.write(n | i | e);
        System.out.println("write header: " + Integer.toHexString(n | i | e) + ",prefix=" + prefix);
        this.writeNSIndex(prefix);
    }

    protected void writeNSIndex(String prefix) throws IOException {
        System.out.println(".writeNSIndex: prefix="+prefix);
        if (prefix == null || prefix.length() == 0) return;
        int index = getPrefixIndexOf(prefix);
        System.out.println(".writeNSIndex: index="+index);
        if (index > 0) {
            this.out.write(this.toVariableLengthNumber(index));
            System.out.println("write ns: " + index + " as " + prefix);
        }
    }

    void writeAttribute(String name, String prefix, String value) throws IOException {
		System.out.println(".writeAttribute["+name+":"+prefix+":"+value+"]");
        int n = (prefix == null || prefix.length() == 0) ? 0x00 : NS_MASK;
        int i = (this.nameMap.containsKey(name)) ? 0x00 : INDEXED_MASK;
        this.out.write(ATTRIBUTE_TAG | n | i);
        System.out.println("write header: " + Integer.toHexString(ATTRIBUTE_TAG | n | i));
        this.writeNSIndex(prefix);
        System.out.println(".writeAttribute: writeNSIndex END");
        this.writeName(name);
		System.out.println(".writeAttribute: writeName END");
        this.writeValue(value);
		System.out.println(".writeAttribute: writeValue END");
    }
}