/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/19 15:27:01
 * 
 */
package jp.grain.sprout.model;

import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Document;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.sprout.OperetionListener;
import jp.grain.sprout.SerializeOperation;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;

/**
 * TODO Instance
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Instance extends DefaultElement implements OperetionListener {

	private static final String NAME = "instance";
	public static final String ATTR_SRC = "src";
    

    private Vector _ancesterPrefixMapping;
	private Document _doc;

	public Instance() {
		super(NAME);
	}

	/**
	 * @throws IOException 
	 * @throws XmlPullParserException 
	 * 
	 */
	public void init(FormContext context) {
		if (getAttribute(ATTR_SRC) != null) {
			SerializeOperation ope = context.createExternalInstanceLoadOperation(this);
			context.execute(ope);
		}
		initInstanceDocument();
	}

	/**
	 * @return
	 */
	private void initInstanceDocument() {
        System.out.println("**** initInstanceDocmenet ***");
		_doc = new Document();
		if (getChildCount() == 0) return;
        
        Element clone = (Element)getChildElement(0).clone();
        for (int i = 0; i < getPrefixMapCount(); i++) {
            clone.addPrefixMapping(getPrefix(i), getNamespace(i));
            System.out.println("instance : prefix = " + getPrefix());
        }
        int start = (_ancesterPrefixMapping == null) ? 0 : _ancesterPrefixMapping.size() - 1;
        for (int i = start; i >= 0; i--) {
            String[] ns = (String[])_ancesterPrefixMapping.elementAt(i);
            System.out.println("ancester : prefix = " + ns[0]);
            clone.addPrefixMapping(ns[0], ns[1]);
        }
        _doc.setRootElement(clone);
        
	}

	public void setInstanceDocument(Document doc) {
		_doc = doc;
	}

    public Document getInstanceDocument() {
        return _doc;
    }    
    
	/**
	 * @return
	 */
	public String getCanonicalSrcUri() {
		return getAttribute(ATTR_SRC);
	}

	/**
	 * @return
	 */
	public Element getRootElement() {
		if (_doc == null) {
			_doc = new Document();
		}
        if (_doc.getRootElement() == null) {
             _doc.setRootElement(new DefaultElement("instanceData"));
        }
		return _doc.getRootElement();
	}

	public void preProcess(Node parent) {
		if (parent instanceof Model) {
			((Model)parent).addInstance(this);
		}
	}

	/**
	 * 
	 */
	public static void init() {
		FormBuilder.registerComponent(NAME, new Instance().getClass());
	}

	/**
	 * @param node
	 * @return
	 */
	public boolean contains(Node node) {
		if (node.getDocument() == _doc)
			return true;
		return false;
	}

	/* (non-Javadoc)
	 * @see jp.grain.sprout.OperetionListener#operationCompleted(jp.grain.sprout.SerializeOperation)
	 */
	public void operationCompleted(SerializeOperation ope) {
	}

	/* (non-Javadoc)
	 * @see jp.grain.sprout.OperetionListener#operationFailure(jp.grain.sprout.SerializeOperation, java.lang.Exception)
	 */
	public void operationFailure(SerializeOperation ope, Exception e) {
	}

    /**
     * @param prefix
     * @param nsUri
     */
    public void addAncesterPrefixMapping(String prefix, String nsUri) {
        if (_ancesterPrefixMapping == null) {
            _ancesterPrefixMapping = new Vector();
        }
        String[] ns = new String[] { prefix, nsUri };
        _ancesterPrefixMapping.addElement(ns);
    }

}
