/*
 * Grain Core - A XForms processor for mobile terminals.
 * Copyright (C) 2005-2006 HAW International Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Created on 2006/01/17 16:19:22
 * 
 */
package jp.grain.sprout.model;

import java.io.IOException;
import java.util.Vector;

import jp.grain.spike.DefaultElement;
import jp.grain.spike.Element;
import jp.grain.spike.Node;
import jp.grain.spike.event.Event;
import jp.grain.sprout.ui.ContextNodeset;
import jp.grain.sprout.ui.Form;
import jp.grain.sprout.ui.FormBuilder;
import jp.grain.sprout.ui.FormContext;


/**
 * TODO Model
 * 
 * @version $Id$
 * @author Go Takahashi
 */
public class Model extends DefaultElement {
    
    public static final String NAME = "model";
    private Vector _instances = new Vector();
    
    public Model() {
        super(NAME);
    }
    
    /**
     * @throws IOException 
     * 
     */
    public void init(FormContext context) throws IOException {
        for (int i = 0; i < _instances.size(); ++i) {
            Instance instance = (Instance)_instances.elementAt(i);
            if (instance == null) continue;
			instance.init(context);
        }
    }
    
    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getText()
     */
    public String getText() {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see jp.grain.spike.Element#getChildText(int)
     */
    public String getChildText(int index) {
        // TODO Auto-generated method stub
        return null;
    }

    /**
     * 
     */
    public void rebuild() {
        Event ev = new Event("xforms-rebuild", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - rebuild computational dependency data structure
        // use preproccessor ?
    }

    /**
     * 
     */
    public void recalculate() {
        Event ev = new Event("xforms-recalcutate", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - recalculate using dependency data structure
        // use preproccessor ?
    }

    /**
     * 
     */
    public void revalidate() {
        Event ev = new Event("xforms-revalidate", true, false);
        dispatchEvent(ev);
        if (ev.isPreventDefault()) return;
        // default action - required and constraint...and so on... are checked
        // and notify that's result.
    }

    /**
     * @return
     */
    public ContextNodeset getContextNodeset() {
        Vector elements = ((Form)getParent()).getBindingElements();
        for (int i = elements.size() - 1; i >= 0; --i) {
            ContextNodeset ctxNodeset = (ContextNodeset)elements.elementAt(i);
            if (ctxNodeset.getModel() == this) {
                return ctxNodeset;
            }
        }
        for (int i = 0; i < getChildCount(); ++i) {
            Element element = (Element)getChildElement(i);
            if (element instanceof Instance) {
                return new ContextNodeset(this, ((Instance)element).getRootElement());            
            }
        }
        return null;
    }
    
    public void preProcess(Node parent) {
        if (parent instanceof Form) {
            ((Form)parent).addModel(this);
        }
    }

    /**
     * 
     */
    public static void init() {
        FormBuilder.registerComponent(NAME, new Model().getClass());
    }
    
    public Instance getInstanceBy(Node node) {
        for (int i = 0; i < _instances.size(); ++i) {
            Instance instance = (Instance)_instances.elementAt(i);
            if (instance.contains(node)) return instance;
        }
        return null;
    }
    
    /**
     * ̃f̎instanceԂ܂B
     * K擪instanceԂ܂Binstance1Ȃꍇ
     * nullԂ܂B
     * 
     * AXPath̉ꎟAK؂ȃ\bhɒu܂B
     * @TODO XPathK؂instanceTĕԂ\bh̍쐬
     * @return
     */
    public Instance getInstance() {
    	if(_instances.size() > 0 ) return (Instance)_instances.elementAt(0);
    	return null;
    }
    /**
     * @param instance
     */
    public void addInstance(Instance instance) {
        _instances.addElement(instance);
    }
    
    /* ( Javadoc)
	 * @see jp.grain.spike.DefaultElement#dispatchEvent(jp.grain.spike.event.Event)
	 */
	public void dispatchEvent(Event event) {
		for(int i=0; i<_instances.size(); i++) {
			((Instance)_instances.elementAt(i)).init();
		}
	}

}
