/*
 * Decompiled with CFR 0.152.
 */
package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.transformer.AbstractTransformer;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Action2Action
extends AbstractTransformer {
    public static final String ACTION_ACTION = "action";
    public static final String ACTION_DISPATCH = "dispatch";
    public static final String ACTION_RWBUILD = "rebuild";
    public static final String ACTION_RECALCULATE = "recalculate";
    public static final String ACTION_REVALIDATE = "revalidate";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_SETFOCUS = "setfocus";
    public static final String ACTION_LOAD = "load";
    public static final String ACTION_SETVALUE = "setvalue";
    public static final String ACTION_SEND = "send";
    public static final String ACTION_RESET = "reset";
    public static final String ACTION_MESSAGE = "message";
    public static final String ACTION_INSERT = "insert";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_SETINDEX = "setindex";
    public static final String[] ACTION_LIST = new String[]{"action", "dispatch", "rebuild", "recalculate", "revalidate", "refresh", "setfocus", "load", "setvalue", "send", "reset", "message", "insert", "delete", "setindex"};

    public Action2Action(GudBuilder builder) {
        super(builder);
    }

    public Element getCurrentElement() {
        return this.current;
    }

    protected boolean isTarget(Node node) {
        if (node.getNodeType() != 1) {
            return false;
        }
        Element e = (Element)node;
        if (e.getNamespaceURI() != "http://www.w3.org/2002/xforms") {
            return false;
        }
        return this.isActionName(e.getLocalName());
    }

    private boolean isActionName(String name) {
        for (int i = 0; i < ACTION_LIST.length; ++i) {
            if (!ACTION_LIST[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public DocumentFragment transform() {
        Document dom = this.builder.getGudDoc();
        DocumentFragment df = dom.createDocumentFragment();
        Element gud_action = dom.createElementNS("http://grain.jp/gud/", ACTION_ACTION);
        Element xforms_action = (Element)this.node;
        Util.copyAttributes(xforms_action, gud_action);
        try {
            String[] targetAttrs = new String[]{};
            if (xforms_action.getLocalName().equals(ACTION_LOAD)) {
                targetAttrs = new String[]{"ref"};
            } else if (xforms_action.getLocalName().equals(ACTION_SETVALUE)) {
                targetAttrs = new String[]{"ref", "value"};
            } else if (xforms_action.getLocalName().equals(ACTION_MESSAGE)) {
                targetAttrs = new String[]{"ref"};
            } else if (xforms_action.getLocalName().equals(ACTION_INSERT)) {
                targetAttrs = new String[]{"nodeset", "at"};
            } else if (xforms_action.getLocalName().equals(ACTION_DELETE)) {
                targetAttrs = new String[]{"nodeset", "at"};
            } else if (xforms_action.getLocalName().equals(ACTION_SETINDEX)) {
                targetAttrs = new String[]{"index"};
            }
            Util.compileNodeBinding(gud_action, targetAttrs);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        if (xforms_action.getLocalName().equals(ACTION_DISPATCH) && xforms_action.getAttribute("name") != null) {
            gud_action.setAttribute("eventtype", xforms_action.getAttribute("name"));
        }
        gud_action.setAttribute("name", xforms_action.getLocalName());
        if (xforms_action.getLocalName().equals(ACTION_ACTION)) {
            this.current = gud_action;
        } else {
            Node parent = xforms_action.getParentNode();
            if (parent == null || !parent.getLocalName().equals(ACTION_ACTION) || !parent.getNamespaceURI().equals("http://www.w3.org/2002/xforms")) {
                Element parent_gud_action = dom.createElementNS("http://grain.jp/gud/", ACTION_ACTION);
                parent_gud_action.setAttributeNS("http://www.w3.org/2001/xml-events", "ev:event", gud_action.getAttributeNS("http://www.w3.org/2001/xml-events", "event"));
                gud_action.removeAttributeNS("http://www.w3.org/2001/xml-events", "event");
                parent_gud_action.setAttribute("name", ACTION_ACTION);
                parent_gud_action.appendChild(gud_action);
                gud_action = parent_gud_action;
                this.current = null;
            }
        }
        if (xforms_action.getLocalName().equals(ACTION_SETVALUE)) {
            this.current = gud_action;
        } else if (xforms_action.getLocalName().equals(ACTION_MESSAGE)) {
            this.current = gud_action;
        }
        df.appendChild(gud_action);
        return df;
    }
}

