package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.TargetNode;
import jp.haw.grain.transform.util.Util;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;


/**
 * font-style=italicɂȂxhtml̗vfinlinevfɕϊ܂B(ex: iƂ)
 * @author nakajo
 */
public class BodyDescendants2Inline extends AbstractTransformer {

	protected String[] targetLocalNames;
	protected String style; //font-style
	protected String size; //font-size
	
	public BodyDescendants2Inline(GudBuilder builder) {
		super(builder);
	}
	

	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTargetLocalName(String localname) {
		for(int i=0; i<this.targetLocalNames.length; i++) {
			if(this.targetLocalNames[i].equals(localname)) return true;
		}
		return false;
	}
	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		//xhtml:bodyȉ̗vf[ƂɂB
		if(!Util.parentNodeAs(node, new TargetNode(GudBuilder.XHTML_NS, "body", Node.ELEMENT_NODE)))
			return false;
        //textContextȂꍇ͑ΏۊO
		if (node.getTextContent().length() == 0) return false;
        
  		return isTargetLocalName(node.getLocalName());
	}

	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		
		DocumentFragment df = dom.createDocumentFragment();
		
		Element gud_inline = dom.createElementNS(GudBuilder.GUD_NS, "inline");
		if(this.style != null) {
			//styleݒ肳ĂΑƂĒǉ
			gud_inline.setAttribute("font-style", this.style);
		}
		if(this.size != null) {
			//sizeݒ肳ĂΑƂĒǉ
			gud_inline.setAttribute("font-size", this.size);
		}

		Util.copyAttributes((Element)node, gud_inline);
		
		//Rs[B
		StringBuffer textBuf = new StringBuffer();
		Util.getTextContent((Element)node, textBuf);
		
		Text inline_text = dom.createTextNode(Util.normalizedString(textBuf.toString()));
		//ϊXLbvXgɓo^
		addSkipList(node);
		
		if(inline_text.getNodeValue() == null || inline_text.getNodeValue().equals("")) {
			//񂪋ۂȂΓo^ȂB
			this.current = null;
			return null;
		}
		
		gud_inline.appendChild(inline_text);
		df.appendChild(gud_inline);
		return df;
	}

	/**
	 * ȍ~̎qvfɂĂ͑Ė邽߂ɃXLbvXgɓo^B
	 * @param node
	 */
	protected void addSkipList(Node node) {
		builder.addSkipNode(node);
		if(node.hasChildNodes()) {
			NodeList children = node.getChildNodes();
			for(int i=0; i<children.getLength(); i++) {
				addSkipList(children.item(i));
			}
		}
	}
	
	/**
	 * @return
	 */
	public String getSize() {
		return size;
	}

	/**
	 * @return
	 */
	public String getStyle() {
		return style;
	}

	/**
	 * @return
	 */
	public String[] getTargetLocalNames() {
		return targetLocalNames;
	}

	/**
	 * @param string
	 */
	public void setSize(String string) {
		size = string;
	}

	/**
	 * @param string
	 */
	public void setStyle(String string) {
		style = string;
	}

	/**
	 * @param strings
	 */
	public void setTargetLocalNames(String[] strings) {
		targetLocalNames = strings;
	}

}
