package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.util.Util;
import jp.haw.grain.xpath.compiler.ParseException;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


/**
 * @author nakajo
 */
public class Submit2Button extends AbstractTransformer {

	public Submit2Button(GudBuilder builder) {
		super(builder);
	}
	
	
	public Element getCurrentElement() {
		return this.current;
	}

	protected boolean isTarget(Node node) {
		if(node.getNodeType() != Node.ELEMENT_NODE) return false;
		
		Element e = (Element)node;
		if(e.getNamespaceURI() != GudBuilder.XFORMS_NS) return false;
		
		return e.getLocalName().equals("submit");
	}

	/* ( Javadoc)
	 * @see jp.haw.grain.transform.Transformer#transform()
	 */
	public DocumentFragment transform() {
		Document dom = builder.getGudDoc();
		DocumentFragment df = dom.createDocumentFragment();
		
		Element xforms_submit = (Element)node;
		Element gud_button = dom.createElementNS(GudBuilder.GUD_NS, "button");
		Element gud_send = dom.createElementNS(GudBuilder.GUD_NS, "action");
		Element gud_action = dom.createElementNS(GudBuilder.GUD_NS, "action");
		gud_button.appendChild(gud_action);
		gud_action.appendChild(gud_send);
		
		//buildereventpNSo^
		builder.addNamespace("ev", GudBuilder.EVENT_NS);
		
		Attr event = dom.createAttributeNS(GudBuilder.EVENT_NS, "ev:event");
		event.setNodeValue("DOMActivate");
		gud_action.setAttributeNodeNS(event);
		gud_send.setAttribute("submission", xforms_submit.getAttribute("submission"));
		
		gud_action.setAttribute("name", "action");
		gud_send.setAttribute("name", "send");
		
		//Rs[
		//refoCgR[hɓWJ
		Util.copyAttributes(xforms_submit, gud_button);
		try {
			Util.compileNodeBinding(gud_button, new String[]{"ref"});
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
		
		gud_button.removeAttribute("submission"); //buttonɂsubmission͗vȂ̂ō폜
		df.appendChild(gud_button);
		
		this.current = gud_button;
		return df;
	}

}
