package jp.haw.grain;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;

/**
 * @author nakajo
 */
public class DivideTest {

	public static void main(String[] args) {
		try {
			//		C̃NX쐬
			WebConversation conversation = new WebConversation();

			//		NGXg쐬
			String url = "http://localhost:8080/sample/SampleServlet";
			InputStream stream = new ByteArrayInputStream(new byte[0]);
			PostMethodWebRequest request = new PostMethodWebRequest(url, stream, "application/gbxml");

			//		CNXoRŃX|XNX擾
			WebResponse response = conversation.sendRequest(request);

			String[] names = response.getHeaderFieldNames();
			for (int i = 0; i < names.length; i++) {
				System.out.println(names[i] + "=" + response.getHeaderField(names[i]));
			}
			int max = Integer.parseInt(response.getHeaderField("X-DIVIDE-MAX-COUNT"));
			String sessionId = response.getHeaderField("X-DIVIDE-SESSION-ID");
			ByteArrayOutputStream out = new ByteArrayOutputStream();
			InputStream in = response.getInputStream();
			BufferedInputStream bIn = new BufferedInputStream(in);
			byte[] buf = new byte[1024];
			while (bIn.read(buf) != -1) {
				out.write(buf);
			}

			for (int i = 2; i < max; i++) {
				System.out.println("\n========================================");
				System.out.println("count=" + i);
				String header = "X-Divide-count: " + i + "\n" + "X-Divide-Session-ID: " + sessionId + "\n\n";
				OutputStream bout = new ByteArrayOutputStream();
				bout.write(header.getBytes());
				stream = new ByteArrayInputStream(header.getBytes());
				
				PostMethodWebRequest request2 = new PostMethodWebRequest(url, stream, "application/xml");
				//		CNXoRŃX|XNX擾
				WebResponse response2 = conversation.getResponse(request2);

				in = response2.getInputStream();
				bIn = new BufferedInputStream(in);
				while (bIn.read(buf) != -1) {
					out.write(buf);
				}

				names = response2.getHeaderFieldNames();
				for (int j = 0; j < names.length; j++) {
					System.out.println(names[j] + "=" + response2.getHeaderField(names[j]));
				}
			}

			System.out.println(new String(out.toByteArray()));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
