package jp.haw.grain.transform;

import junit.framework.TestCase;

public class GudBuilderTest extends TestCase {

	public void testAction() {
		GudConverter conv = new GudConverter(testData);
		try {
			assertEquals("convert result check", testDataResult, conv.convert());
		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static final String testData = "<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>" +
"<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xforms=\"http://www.w3.org/2002/xforms\" xmlns:gr=\"http://grain.jp/grain\" xmlns:ev=\"http://www.w3.org/2001/xml-events\" xmlns:my=\"http://www.haw.co.jp/ns/my\">" +
	"<head>" +
		"<title>gml tab-block test</title>" +
		"<xforms:model>" +
			"<xforms:instance>" +
				"<data xmlns=\"\">" +
					"<lines name=\"lines-test\">" +
						"<line name=\"a\">" +
							"<price>3.00</price>" +
						"</line>" +
						"<line name=\"b\">" +
							"<price>32.25</price>" +
						"</line>" +
						"<line name=\"c\">" +
							"<price>132.99</price>" +
						"</line>" +
					"</lines>" +
				"</data>" +
			"</xforms:instance>" +
		"</xforms:model>" +
	"</head>" +

	"<body>" +
		"<p>" +
			"<xforms:repeat id=\"lineset\" nodeset=\"/data/lines/line\">" +
				"<xforms:input ref=\"price\">" +
					"<xforms:label>li</xforms:label>" +
				"</xforms:input>" +
				"<xforms:input ref=\"price\">" +
					"<xforms:label></xforms:label>" +
				"</xforms:input><br/>" +
			"</xforms:repeat>" +
			"<xforms:trigger>" +
				"<xforms:label>Viڂ݂̕iڂ̌ɒǉ</xforms:label>" +
				"<xforms:action ev:event=\"DOMActivate\">" +
					"<xforms:insert nodeset=\"/data/lines/line\" at=\"index('lineset')\" position=\"after\"/>" +
					"<xforms:setvalue ref=\"/data/lines/line[index('lineset')]/@name\"/>" +
					"<xforms:setvalue ref=\"/data/lines/line[index('lineset')]/price\">0.00</xforms:setvalue>" +
				"</xforms:action>" +
			"</xforms:trigger>" +
			"<xforms:trigger>" +
				"<xforms:label>݂̕iڂ폜</xforms:label>" +
				"<xforms:delete ev:event=\"DOMActivate\" nodeset=\"/data/lines/line\" at=\"index('lineset')\"/>" +
			"</xforms:trigger>" +
		"</p>" +
	"</body>" +
"</html>";

	public static final String testDataResult = "<?xml version=\"1.0\" encoding=\"Shift_JIS\"?>\n" +
			"<form xmlns=\"http://grain.jp/gud/\" xmlns:ev=\"http://www.w3.org/2001/xml-events\" xmlns:gr=\"http://grain.jp/grain\" xmlns:my=\"http://www.haw.co.jp/ns/my\" xmlns:xpath=\"http://grain.jp/xpath/\">" +
				"<model>" +
					"<instance>" +
						"<data xmlns=\"\">" +
							"<lines name=\"lines-test\">" +
								"<line name=\"a\">" +
									"<price>3.00</price>" +
								"</line>" +
								"<line name=\"b\">" +
									"<price>32.25</price>" +
								"</line>" +
								"<line name=\"c\">" +
									"<price>132.99</price>" +
								"</line>" +
							"</lines>" +
						"</data>" +
					"</instance>" +
				"</model>" +
				"<view title=\"gml tab-block test\">" +
					"<inline-block>" +
						"<repeat id=\"lineset\">" +
							"<xpath:expr name=\"nodeset\">" +
								"<xpath:_child/>" +
								"<xpath:_child/>" +
								"<xpath:_child/>" +
								"<xpath:_absolute/>" +
								"<xpath:ctxnload/>" +
								"<xpath:step _0=\"\" _1=\"\"/>" +
								"<xpath:step _0=\"data\" _1=\"\"/>" +
								"<xpath:step _0=\"lines\" _1=\"\"/>" +
								"<xpath:step _0=\"line\" _1=\"\"/>" +
							"</xpath:expr>" +
							"<textbox>" +
								"<xpath:expr name=\"ref\">" +
									"<xpath:_child/>" +
									"<xpath:ctxnload/>" +
									"<xpath:step _0=\"price\" _1=\"\"/>" +
								"</xpath:expr>" +
								"<label>li</label>" +
							"</textbox>" +
							"<textbox>" +
								"<xpath:expr name=\"ref\">" +
									"<xpath:_child/>" +
									"<xpath:ctxnload/>" +
									"<xpath:step _0=\"price\" _1=\"\"/>" +
								"</xpath:expr>" +
								"<label></label>" +
							"</textbox>" +
							"<inline break=\"true\"/>" +
						"</repeat>" +
						"<button>" +
							"<label>Viڂ݂̕iڂ̌ɒǉ</label>" +
								"<action ev:event=\"DOMActivate\" name=\"action\">" +
								"<action name=\"insert\" position=\"after\">" +
									"<xpath:expr name=\"nodeset\">" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_absolute/>" +
										"<xpath:ctxnload/>" +
										"<xpath:step _0=\"\" _1=\"\"/>" +
										"<xpath:step _0=\"data\" _1=\"\"/>" +
										"<xpath:step _0=\"lines\" _1=\"\"/>" +
										"<xpath:step _0=\"line\" _1=\"\"/>" +
									"</xpath:expr>" +
									"<xpath:expr name=\"at\">" +
										"<xpath:spush _0=\"lineset\"/>" +
										"<xpath:fcall _0=\"index\" _1=\"1\"/>" +
									"</xpath:expr>" +
								"</action>" +
								"<action name=\"setvalue\">" +
									"<xpath:expr name=\"ref\">" +
										"<xpath:_attribute/>" +
										"<xpath:clspush>" +
											"<xpath:spush _0=\"lineset\"/>" +
											"<xpath:fcall _0=\"index\" _1=\"1\"/>" +
										"</xpath:clspush>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_absolute/>" +
										"<xpath:ctxnload/>" +
										"<xpath:step _0=\"\" _1=\"\"/>" +
										"<xpath:step _0=\"data\" _1=\"\"/>" +
										"<xpath:step _0=\"lines\" _1=\"\"/>" +
										"<xpath:step _0=\"line\" _1=\"\"/>" +
										"<xpath:filter/>" +
										"<xpath:step _0=\"name\" _1=\"\"/>" +
									"</xpath:expr>" +
								"</action>" +
								"<action name=\"setvalue\">" +
									"<xpath:expr name=\"ref\">" +
										"<xpath:_child/>" +
										"<xpath:clspush>" +
											"<xpath:spush _0=\"lineset\"/>" +
											"<xpath:fcall _0=\"index\" _1=\"1\"/>" +
										"</xpath:clspush>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_absolute/>" +
										"<xpath:ctxnload/>" +
										"<xpath:step _0=\"\" _1=\"\"/>" +
										"<xpath:step _0=\"data\" _1=\"\"/>" +
										"<xpath:step _0=\"lines\" _1=\"\"/>" +
										"<xpath:step _0=\"line\" _1=\"\"/>" +
										"<xpath:filter/>" +
										"<xpath:step _0=\"price\" _1=\"\"/>" +
									"</xpath:expr>" +
									"0.00" +
								"</action>" +
							"</action>" +
						"</button>" +
						"<button>" +
							"<label>݂̕iڂ폜</label>" +
							"<action ev:event=\"DOMActivate\" name=\"action\">" +
								"<action name=\"delete\">" +
									"<xpath:expr name=\"nodeset\">" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_child/>" +
										"<xpath:_absolute/>" +
										"<xpath:ctxnload/>" +
										"<xpath:step _0=\"\" _1=\"\"/>" +
										"<xpath:step _0=\"data\" _1=\"\"/>" +
										"<xpath:step _0=\"lines\" _1=\"\"/>" +
										"<xpath:step _0=\"line\" _1=\"\"/>" +
									"</xpath:expr>" +
									"<xpath:expr name=\"at\">" +
										"<xpath:spush _0=\"lineset\"/>" +
										"<xpath:fcall _0=\"index\" _1=\"1\"/>" +
									"</xpath:expr>" +
								"</action>" +
							"</action>" +
						"</button>" +
					"</inline-block>" +
				"</view>" +
			"</form>";

}
