package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Action2ActionTest extends TestCase {

	/**
	 * action̂Ƃ͂̂܂܃Rs[
	 * ϊʂcurrentAĂ
	 *
	 */
	public void testAction() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "action", null);
		Element action = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "action");
		action.setAttributeNS(GudBuilder.EVENT_NS, "ev:event", "DOMActivate");
		
		Action2Action a2action = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Element action = (Element)nodes.item(0);
				assertEquals("transformed element check", "action", action.getNodeName());
				assertEquals("transformed element name attribute check", "action", action.getAttribute("name"));
				assertEquals("transformed element ev:event attribute check", "DOMActivate", action.getAttributeNS(GudBuilder.EVENT_NS, "event"));

				assertEquals("children size check", action.getChildNodes().getLength(), 0);
				assertEquals("check transformer current Element", t.getCurrentElement().getLocalName(), "action");
				assertEquals("check transformer current Element name attribute", t.getCurrentElement().getAttribute("name"), "action");
			}
		};

		a2action.apply(action, mockOperation);
	}

	/**
	 * dispatcĥƂ̕ϊeXg
	 * eactionvfB
	 * nameeventtypeɂȂ
	 * ev:eventeɃRs[
	 * transformercurrentnullɂȂB
	 *
	 */
	public void testDispatch() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "action", null);
		Element dispatch = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "dispatch");
		dispatch.setAttribute("name", "xforms-refresh");
		dispatch.setAttributeNS(GudBuilder.EVENT_NS, "ev:event", "DOMActivate");
		
		Action2Action a2action = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Element action = (Element)nodes.item(0);
				assertEquals("transformed element check", "action", action.getNodeName());
				assertEquals("transformed element name attribute check", "action", action.getAttribute("name"));
				assertEquals("transformed element ev:event attribute check", "DOMActivate", action.getAttributeNS(GudBuilder.EVENT_NS, "event"));

				assertEquals("children size check", action.getChildNodes().getLength(), 1);
				
				Element dispatch = (Element)action.getChildNodes().item(0);
				assertEquals("transformed element child check", "action", dispatch.getNodeName());
				assertEquals("transformed element child name attribute check", "dispatch", dispatch.getAttribute("name"));
				assertEquals("transformed element eventtype attribute check", "xforms-refresh", dispatch.getAttribute("eventtype"));
				assertNull("transformer current is null", t.getCurrentElement());
			}
		};

		a2action.apply(dispatch, mockOperation);
	}

	class MockTransformer extends Action2Action {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
