package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * @author nakajo
 */
public class Text2InlineTest extends TestCase {
	
	/**
	 * xhtmlbodyvf̎qvfłeLXginlinevfɕϊB
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Text text = simpleDoc.createTextNode("eXg");
		body.appendChild(text);
		
		Text2Inline text2inline = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline");
				assertEquals("same text check", node.getTextContent(), "eXg");
				
				assertTrue("current is not null check", t.getCurrentElement() == null);
			}
		};

		text2inline.apply(text, mockOperation);
	}

	/**
	 * xhtmlbodyvf̎qvfłeLXginlinevfɕϊB
	 *
	 */
	public void testDeep() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "div");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Text text = simpleDoc.createTextNode("eXg");
		
		body.appendChild(div);
		div.appendChild(span);
		span.appendChild(p);
		p.appendChild(text);
		
		Text2Inline text2inline = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				NodeList nodes = df.getChildNodes();
				assertEquals("list length check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertEquals("name check", node.getLocalName(), "inline");
				assertEquals("same text check", node.getTextContent(), "eXg");
				
				assertTrue("current is not null check", t.getCurrentElement() == null);
			}
		};

		text2inline.apply(text, mockOperation);
	}



	/**
	 * c悪bodyȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testNotXFormsTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "html", null);
		Element body = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "div");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Text text = simpleDoc.createTextNode("eXg");
		Text text2 = simpleDoc.createTextNode("eXg2");
		
		body.appendChild(div);
		body.appendChild(text2);
		div.appendChild(span);
		span.appendChild(p);
		p.appendChild(text);
		
		Text2Inline text2inline = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		text2inline.apply(text, mockOperation);
		mockOperation.createChildNodeOperation();
		text2inline.apply(text2, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * NSXHTMLȂ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testWrongNS() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "div");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Text text = simpleDoc.createTextNode("eXg");
		Text text2 = simpleDoc.createTextNode("eXg2");
		
		body.appendChild(div);
		body.appendChild(text2);
		div.appendChild(span);
		span.appendChild(p);
		p.appendChild(text);
		

		Text2Inline text2inline = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		text2inline.apply(text, mockOperation);
		mockOperation.createChildNodeOperation();
		text2inline.apply(text2, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * text󔒕Ȃ̂ŕϊΏۂɂȂȂ
	 *
	 */
	public void testEmptyText() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "body", null);
		Element body = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "div");
		Element span = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "span");
		Element p = simpleDoc.createElementNS(GudBuilder.XHTML_NS, "p");
		Text text = simpleDoc.createTextNode("");
		Text text2 = simpleDoc.createTextNode("\t\t");
		
		body.appendChild(div);
		body.appendChild(text2);
		div.appendChild(span);
		span.appendChild(p);
		p.appendChild(text);
		

		Text2Inline text2inline = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		text2inline.apply(text, mockOperation);
		mockOperation.createChildNodeOperation();
		text2inline.apply(text2, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends Text2Inline {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
