package jp.haw.grain.transform.transformer;

import jp.haw.grain.transform.GudBuilder;
import jp.haw.grain.transform.TransformOperation;
import junit.framework.TestCase;

import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author nakajo
 */
public class DivAndGroup2BlockTest extends TestCase {

	/**
	 * div^OblockɕϊVvȃeXg
	 *
	 */
	public void testSimpleTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "div", null);
		Element div = simpleDoc.getDocumentElement();
		
		DivAndGroup2Block dg2b = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node inline = nodes.item(0);
				assertTrue("block name check", inline.getNodeName().equals("block"));
				assertTrue("current is not null check", t.getCurrentElement() != null);
			}
		};

		dg2b.apply(div, mockOperation);
	}

	/**
	 * groupblockɂ
	 *
	 */
	public void testSimpleTag2() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "group", null);
		Element group = simpleDoc.getDocumentElement();
		
		DivAndGroup2Block dg2b = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node inline = nodes.item(0);
				assertTrue("block name check", inline.getNodeName().equals("block"));
				assertTrue("current is not null check", t.getCurrentElement() != null);
			}
		};

		dg2b.apply(group, mockOperation);
	}

	/**
	 * Rs[
	 *
	 */
	public void testCopyAttrs() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XFORMS_NS, "group", null);
		Element group = simpleDoc.getDocumentElement();
		group.setAttribute("ev:event", "DOMActivate");
		group.setAttribute("id", "hog1");
		group.setAttribute("padding", "2px");
		
		DivAndGroup2Block dg2b = new MockTransformer(new GudBuilder(simpleDoc), true);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#operation(jp.haw.grain.transform.transformer.AbstractTransformer)
			 */
			public void operation(AbstractTransformer t) {
				DocumentFragment df = t.transform();
				assertTrue(df.hasChildNodes());
				NodeList nodes = df.getChildNodes();
				assertEquals("size check", nodes.getLength(), 1);
				Node node = nodes.item(0);
				assertTrue("inline-block name check", node.getNodeName().equals("block"));
				assertTrue("current is not null check", t.getCurrentElement() != null);
				
				NamedNodeMap attrs = node.getAttributes();
				assertEquals("attrs length check", attrs.getLength(), 3);
				Node event = attrs.getNamedItem("ev:event");
				Node id = attrs.getNamedItem("id");
				Node padding = attrs.getNamedItem("padding");
				
				assertTrue("event not null check", event != null);
				assertTrue("id not null check", id != null);
				assertTrue("padding not null check", padding != null);

				assertEquals("event same value check", event.getNodeValue(), "DOMActivate");
				assertEquals("id same value check", id.getNodeValue(), "hog1");
				assertEquals("padding same value check", padding.getNodeValue(), "2px");
			}
		};

		dg2b.apply(group, mockOperation);
	}
	
	
	/**
	 * NSꂩĂ݂BϊȂ
	 *
	 */
	public void testWrongNSTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "group", null);
		Element group = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "div");
		
		DivAndGroup2Block dg2b = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		dg2b.apply(group, mockOperation);
		mockOperation.createChildNodeOperation();
		dg2b.apply(div, mockOperation);
		mockOperation.createChildNodeOperation();
	}

	/**
	 * OႤ^O͕ϊȂB
	 *
	 */
	public void testWrongLocalNameTag() {
		DOMImplementation domi = new DOMImplementationImpl();
		Document gudDoc = domi.createDocument("http://grain.jp/gud/", "form", null);
		Document simpleDoc = domi.createDocument(GudBuilder.XHTML_NS, "span", null);
		Element group = simpleDoc.getDocumentElement();
		Element div = simpleDoc.createElementNS(GudBuilder.XFORMS_NS, "input");
		
		DivAndGroup2Block dg2b = new MockTransformer(new GudBuilder(simpleDoc), false);
		TransformOperation mockOperation = new TransformOperation(gudDoc.getDocumentElement()) {
			/* ( Javadoc)
			 * @see jp.haw.grain.transform.TransformOperation#createChildNodeOperation()
			 */
			public TransformOperation createChildNodeOperation() {
				assertEquals("transformer null check", this.transformer, null);
				// TODO ꂽ\bhEX^u
				return super.createChildNodeOperation();
			}

		};

		dg2b.apply(group, mockOperation);
		mockOperation.createChildNodeOperation();
		dg2b.apply(div, mockOperation);
		mockOperation.createChildNodeOperation();
	}
	
	class MockTransformer extends DivAndGroup2Block {
		protected boolean targetResult;
		/**
		 * @param builder
		 */
		public MockTransformer(GudBuilder builder, boolean targetResult) {
			super(builder);
			this.targetResult = targetResult;
		}
		
		/* ( Javadoc)
		 * @see jp.haw.grain.transform.transformer.AbstractTransformer#isTarget(org.w3c.dom.Node)
		 */
		protected boolean isTarget(Node node) {
			assertEquals("apply check", super.isTarget(node), this.targetResult);
			return super.isTarget(node);
		}

	}
}
