package jp.sf.grizzly.storage;

import java.io.InputStream;
import java.io.OutputStream;

public interface StreamStorage
{
    /**
     *  Initialize this StreamStorage object.
     * 
     * @param in an input stream that you want to convert
     * @param encoding an encoding for the given input stream
     * @throws StreamStorageException
     */
    public abstract void init(InputStream in, String encoding)
            throws StreamStorageException;

    /**
     *  Destroys instances, such as caches, in this class
     */
    public abstract void destroy();

    /**
     *  Commits a written output stream, and then you can get the commited 
     *  stream from getInputStream().
     * 
     * @throws StreamStorageException
     */
    public abstract void commit() throws StreamStorageException;

    /**
     * @return Returns the converted byte stream.
     * @throws StreamStorageException
     */
    public abstract InputStream getResultInputStream()
            throws StreamStorageException;

    /**
     * @return Returns the encoding.
     */
    public abstract String getEncoding();

    /**
     * @return Returns the inputStream.
     */
    public abstract InputStream getInputStream();

    /**
     * @return Returns the outputStream.
     */
    public abstract OutputStream getOutputStream();
}
