package jp.sf.grizzly.pipeline.valve.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.pipeline.valve.AbstractValve;
import jp.sf.grizzly.pipeline.valve.ValveContext;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringReplaceAllValve extends AbstractValve
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(StringReplaceAllValve.class);

    private String regex = null;

    private String replacement = null;

    public StringReplaceAllValve()
    {
    }

    /**
     * This valve calls String#replaceAll(String, String) method.
     * 
     * @param regex   
     * @param replacement 
     */
    public StringReplaceAllValve(String regex, String replacement)
    {
        setRegex(regex);
        setReplacement(replacement);
    }

    public void invoke(StreamStorage storage, ValveContext context)
            throws PipelineException
    {
        BufferedReader reader = null;
        try
        {
            reader = new BufferedReader(new InputStreamReader(storage
                    .getInputStream(), storage.getEncoding()));
        }
        catch (UnsupportedEncodingException e)
        {
            log.warn("Unsupported Encoding. ", e);
            reader = new BufferedReader(new InputStreamReader(storage
                    .getInputStream()));
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(
                storage.getOutputStream()));

        String line = null;
        try
        {
            if (regex != null && replacement != null)
            {
                while ((line = reader.readLine()) != null)
                {
                    writer.write(new String(line + "\n").replaceAll(regex,
                            replacement));
                }
            }
            else
            {
                // Invalid Argument!!
                while ((line = reader.readLine()) != null)
                {
                    writer.write(line);
                    writer.write("\n");
                }
            }
            writer.flush();
            storage.commit();
        }
        catch (StreamStorageException e)
        {
            log.error("Stream Storage Exception. ", e);
            throw new PipelineException(e);
        }
        catch (IOException e)
        {
            log.error("Stream Storage Exception. ", e);
            throw new PipelineException(e);
        }

        context.invokeNext(storage);

    }

    /**
     * @return Returns the replacement.
     */
    public String getReplacement()
    {
        return replacement;
    }

    /**
     * @param replacement The replacement to set.
     */
    public void setReplacement(String newString)
    {
        this.replacement = newString;
    }

    /**
     * @return Returns the regex.
     */
    public String getRegex()
    {
        return regex;
    }

    /**
     * @param regex The regex to set.
     */
    public void setRegex(String oldString)
    {
        this.regex = oldString;
    }
}
