package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

public class ConvertNumberListValve extends AbstractHatenaValve
{

	private String pattern = "^[\\+].*?";

	private boolean tagStartFlg;

	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(!tagStartFlg)
		{
			writer.write("<ol>");
			writer.newLine();
			tagStartFlg = true;
		}
		writer.write("<li>" + line.substring(1) + "</li>");
		writer.newLine();
	}

	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</ol>");
			writer.newLine();
			tagStartFlg = false;
			super.writeUnmatchLine(writer,line);
		}
		else
		{
			super.writeUnmatchLine(writer, line);
		}
	}

	protected void finish(BufferedWriter writer) throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</ol>");
			writer.newLine();
			tagStartFlg = false;
		}
		else
		{
			super.finish(writer);
		}
	}
}
