package jp.sf.grizzly.hatena.pipeline.valve;

import java.io.BufferedWriter;
import java.io.IOException;

public class ConvertTableValve extends AbstractHatenaValve
{
	private String pattern = "\\|.*\\|$";

	private boolean tagStartFlg;

	protected String getPattern()
	{
		return pattern;
	}

	protected void writeMatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(!tagStartFlg)
		{
			writer.write("<table>");
			writer.newLine();
			tagStartFlg = true;
		}
		String[] values = line.split("\\|");		
		writer.write("<tr>");
		for(int i=1;i<values.length;i++)
		{
			String s = values[i];
			if(s.startsWith("*")) 
			{
				s = s.substring(1);
				writer.write("<th>" + s + "</th>");
			}else
			{
				writer.write("<td>" + s + "</td>");
			}
		}
		writer.write("</tr>");
		writer.newLine();
	}

	protected void writeUnmatchLine(BufferedWriter writer, String line)
			throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</table>");
			writer.newLine();
			writer.write(line);
			writer.newLine();
			tagStartFlg = false;
		}
		else
		{
			super.writeUnmatchLine(writer, line);
		}
	}

	protected void finish(BufferedWriter writer) throws IOException
	{
		if(tagStartFlg)
		{
			writer.write("</table>");
			writer.newLine();
			tagStartFlg = false;
		}
		else
		{
			super.finish(writer);
		}
	}
}
