
#==============================================================================#
# gruby/fill.rb
# $Id: fill.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

#==============================================================================#
# GRb Class
class GRb

  #============================================================================#
  # Fill Class
  class Fill

    def initialize(color = nil, opacity = nil)
      @color   = color
      @opacity = opacity || 100
    end

    attr_accessor :color, :opacity

    def self.new_from(style)
      case style
      when Fill     then return style
      when Color    then return self.new(style)
      when Hash     then return self.new_from_hash(style)
      when NilClass then return self.new
      else raise TypeError, "GRb::Fill or GRb::Color or Hash required"
      end
    end
    
    def self.new_from_hash(hash)
      fill = self.new
      fill.color   = hash[:color]
      fill.opacity = hash[:opacity] || 100
      return fill
    end

    def draw?
      return (!!@color && @opacity > 0)
    end

    def set(image)
      return @color.set(image)
    end

  end # Fill
  
end # GRb

#==============================================================================#
#==============================================================================#
