
#==============================================================================#
# $Id: primitive.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Attribute

    module Primitive

      class Border

        def initialize
          @visible = nil
          @color   = nil
          @width   = nil
        end

        attr_accessor :visible, :color, :width

        def create_decorator(child)
          if @visible
            decorator = Decorator::Border.new(child)
            decorator.color = @color || Color.black
            decorator.width = @width || 1
            return decorator
          else
            return child
          end
        end

      end # Border

      class Fill

        def initialize
          @visible = nil
          @color   = nil
          @opacity = nil
        end

        attr_accessor :visible, :color, :opacity

        def create_decorator(child)
          if @visible
            decorator = Decorator::Fill.new(child)
            decorator.color   = @color   || Color.white
            decorator.opacity = @opacity || 100
            return decorator
          else
            return child
          end
        end

      end # Fill

      class Padding

        def initialize
          @left   = nil
          @right  = nil
          @top    = nil
          @bottom = nil
        end

        attr_accessor :left, :right, :top, :bottom

        def create_decorator(child)
          decorator = Decorator::Padding.new(child)
          decorator.spacing_left   = @left   || 0
          decorator.spacing_right  = @right  || 0
          decorator.spacing_top    = @top    || 0
          decorator.spacing_bottom = @bottom || 0
          return decorator
        end

      end # Padding

      class Picture

        def initialize
          @visible  = nil
          @filepath = nil
          @opacity  = nil
        end

        attr_accessor :visible, :filepath, :opacity

        def create_decorator(child)
          if @visible && @filepath
            decorator = Decorator::Picture.new(child)
            decorator.filepath = @filepath
            decorator.opacity  = @opacity || 100
            return decorator
          else
            return child
          end
        end

      end # Picture

      class Shadow

        def initialize
          @visible  = nil
          @color    = nil
          @offset_x = nil
          @offset_y = nil
        end

        attr_accessor :visible, :color, :offset_x, :offset_y

        def create_decorator(child)
          if @visible
            decorator = Decorator::Shadow.new(child)
            decorator.color    = @color    || Color.gray(128)
            decorator.offset_x = @offset_x || 2
            decorator.offset_y = @offset_y || 2
            return decorator
          else
            return child
          end
        end

      end # Shadow

      class Gradation

        def initialize
          @visible     = nil
          @start_color = nil
          @end_color   = nil
          @angle       = nil
          @opacity     = nil
        end

        attr_accessor :visible, :start_color, :end_color, :angle, :opacity

        def create_decorator(child)
          if @visible
            decorator = Decorator::Gradation.new(child)
            decorator.color_start = @start_color || Color.white
            decorator.color_end   = @end_color   || Color.black
            decorator.direction   = @angle       || 0
            decorator.opacity     = @opacity     || 100
            return decorator
          else
            return child
          end
        end

      end # Gradation

      class Font

        def initialize
          # common
          @color    = nil

          # for GD Font
          @name     = nil
          @vertical = nil

          # for TrueType Font
          @filepath = nil
          @size     = nil
          @angle    = nil
        end

        attr_accessor :color, :name, :vertical, :filepath, :size, :angle

        def create_font
          if @name
            color    = @color    || Color.black
            vertical = @vertical || false
            font = Graph::Font.gd(@name, color, vertical)
          elsif @filepath
            color = @color || Color.black
            size  = @size  || 10
            angle = @angle || 0
            font = Graph::Font.truetype(@filepath, size, color, angle)
          else
            raise ArgumentError, "Can't create font. [name] and [filepath] is nil."
          end

          return font
        end

      end # Font

      class MajorMinor

        def initialize(major = nil, minor = nil)
          @major = major
          @minor = minor
        end

        attr_accessor :major, :minor

      end # MajorMinor

    end # Primitive

  end # Attribute

end # Graph
