
#==============================================================================#
# $Id: line.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

require 'ggcl/extension/array'
require 'ggcl/extension/enumerable'

# Graph Module
module Graph

  # Chart Module
  module Chart

    # Line Class
    class Line < XYBase

      # Initialize Method

      def initialize(attribute)
        super(attribute)
      end

      # Private Instance Methods

      def create_chart(major_scale, items)
        return @value_set.collect { |value_set|
          chart = LineChart.new
          chart.scale  = major_scale
          chart.value  = (value_set.values + [nil] * items)[0, items]
          chart.color  = value_set.color
          chart.marker = value_set.marker
          chart
        }
      end
      private :create_chart

      # Instance Methods

      def draw(image, box)
        major_scale = create_major_scale(@attribute.scale1)
        minor_scale = create_minor_scale(@attribute.scale1)

        items = @value_set.collect { |value_set| value_set.values.size }.max

        graph_layer = create_layer(major_scale, minor_scale, items)
        scale_label = create_scale_label(major_scale)
        axis_label  = create_axis_label(items)

        layout = Layout.new(graph_layer, scale_label, axis_label)
        layout.draw(image, box)
      end

      # LineChart Class
      class LineChart
        def initialize
          @scale  = nil
          @value  = nil
          @color  = nil
          @marker = nil
        end
        attr_accessor :scale, :value, :color, :marker
        def draw(image, box)
          color = @color.allocate(image)
          point = calculate(@value, @scale, box)

          point.peep(2) { |(x1, y1), (x2, y2)|
            if x1 && y1 && x2 && y2
              image.line(x1, y1, x2, y2, color)
            end
          }

          if @marker
            point.each { |x, y|
              if x && y
                @marker.draw(image, x, y)
              end
            }
          end
        end
        def calculate(value, scale, box)
          width = (box.dx - 1).to_f / value.size
          raito = scale.raito(box.dy - 1)
          start = box.x + width / 2.0

          return value.collect_with_index { |val, index|
            if val
              x = start + width * index
              y = box.y2 - (val - scale.minimum) * raito
              [x, y]
            else
              [nil, nil]
            end
          }
        end
      end # LineChart

    end # Line

  end # Chart

end # Graph
