
#==============================================================================#
# $Id: gradation.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

require 'ggcl/math/math'

module Graph

  module Decorator

    class Gradation < Base

      def initialize(child = nil)
        super(child)

        @color_start = Color.new(0, 0, 0)
        @color_end   = Color.new(255, 255, 255)
        @direction   = 0
        @opacity     = 100
      end

      attr_accessor :color_start, :color_end, :direction, :opacity

      def draw_self(image, box)
        x     = box.x
        y     = box.y
        dx    = box.dx
        dy    = box.dy
        angle = @direction

        w1    = GGCL::Math.sin(angle) * dx
        w2    = GGCL::Math.sin(angle) * dy
        delta = (GGCL::Math.sin(angle) * dx).abs + (GGCL::Math.cos(angle) * dy).abs

        case angle % 360
        when 0..90
          x1 = (GGCL::Math.cos(angle + 270) * w1).floor
          y1 = (GGCL::Math.sin(angle + 270) * w1).floor
          x2 = (GGCL::Math.cos(angle)       * w2).floor + dx
          y2 = (GGCL::Math.sin(angle)       * w2).floor
        when 90..180
          x1 = (GGCL::Math.cos(angle + 180) * w2).floor + dx
          y1 = (GGCL::Math.sin(angle + 180) * w2).floor + dy
          x2 = (GGCL::Math.cos(angle + 270) * w1).floor
          y2 = (GGCL::Math.sin(angle + 270) * w1).floor + dy
        when 180..270
          x1 = (GGCL::Math.cos(angle + 90)  * w1).floor + dx
          y1 = (GGCL::Math.sin(angle + 90)  * w1).floor + dy
          x2 = (GGCL::Math.cos(angle + 180) * w2).floor
          y2 = (GGCL::Math.sin(angle + 180) * w2).floor + dy
        when 270..360
          x1 = (GGCL::Math.cos(angle)       * w2).floor
          y1 = (GGCL::Math.sin(angle)       * w2).floor
          x2 = (GGCL::Math.cos(angle + 90)  * w1).floor + dx
          y2 = (GGCL::Math.sin(angle + 90)  * w1).floor
        else
          raise 'bug?'
        end

        delta_red   = @color_start.red   - @color_end.red
        delta_green = @color_start.green - @color_end.green
        delta_blue  = @color_start.blue  - @color_end.blue

        raito_red   = delta_red.to_f   / delta.to_f
        raito_green = delta_green.to_f / delta.to_f
        raito_blue  = delta_blue.to_f  / delta.to_f

        raito_x = GGCL::Math.cos(angle + 90)
        raito_y = GGCL::Math.sin(angle + 90)

        frame = GD::Image.new(dx, dy)

        (0..delta.ceil).each { |i|
          red   = @color_start.red   - raito_red   * i
          green = @color_start.green - raito_green * i
          blue  = @color_start.blue  - raito_blue  * i

          red   = [[red.to_i,   0].max, 255].min
          green = [[green.to_i, 0].max, 255].min
          blue  = [[blue.to_i,  0].max, 255].min

          xx1 = (x1 + raito_x * i).floor
          yy1 = (y1 + raito_y * i).floor
          xx2 = (x2 + raito_x * i).floor
          yy2 = (y2 + raito_y * i).floor

          brush = GD::Image.new(2, 2)
          brush.colorAllocate(red, green, blue)
          frame.setBrush(brush)
          frame.line(xx1, yy1, xx2, yy2, GD::Brushed)
          brush.destroy
        }

        if @opacity > 0
          if @opacity >= 100
            frame.copy(image, x, y, 0, 0, dx, dy)
          else
            frame.copyMerge(image, x, y, 0, 0, dx, dy, @opacity)
          end
        end

        frame.destroy
      end

      def draw_child(image, box)
        @child.draw(image, box)
      end

    end

  end

end
