
#==============================================================================#
# $Id: layer.rb,v 1.2 2002/09/18 15:43:59 yuya Exp $
#==============================================================================#

module Graph

  module Decorator

    class Layer < Base

      # Initialize Method

      def initialize
        super(nil)
        @children = []
      end

      # Private Instance Methods

      def has_child?
        return !@children.empty?
      end
      private :has_child?

      def draw_self(image, box)
        # nop
      end
      private :draw_self

      def draw_child(image, box)
        @children.compact.each { |child|
          child.draw(image, box)
        }
      end
      private :draw_child

      # Instance Methods

      def <<(child)
        if child.kind_of?(Array)
          child.each { |item| @children << item }
        else
          @children << child
        end
      end

      def dx
        unless @children.empty?
          return @children.collect { |child| child.dx }.max
        else
          return 0
        end
      end

      def dy
        unless @children.empty?
          return @children.collect { |child| child.dy }.max
        else
          return 0
        end
      end

    end

  end

end
